# Klimaks.com Installation Guide

## Prerequisites
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache/Nginx web server
- Composer
- Node.js & npm (for Tailwind CSS)

## Installation Steps

### 1. Database Setup
```bash
# Create database
mysql -u root -p < database/klimaks_install.sql

# Or manually:
CREATE DATABASE klimaks_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### 2. Configure Environment
```bash
# Update database configuration
# Edit application/config/database.php
# Set your database credentials
```

### 3. Install Dependencies
```bash
# Install PHP dependencies via Composer
composer install

# Install Node.js dependencies
npm install
```

### 4. Run Database Migration
```bash
# Run CodeIgniter migrations
php index.php migrate
```

### 5. Set Up Web Server
```apache
# Apache .htaccess (already included)
# Nginx configuration
server {
    listen 80;
    server_name klimaks.local;
    root /path/to/klimaks;
    index index.php;
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
    
    location ~ \.php$ {
        fastcgi_pass 127.0.0.1:9000;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

### 6. Initial Setup
1. Access the admin panel at `/admin`
2. Login with default credentials:
   - Username: admin
   - Password: admin123
3. Change default admin password
4. Configure site settings
5. Set up CDN and storage (optional)

### 7. Security Configuration
- Enable HTTPS
- Configure file upload limits
- Set up rate limiting
- Configure email settings

## Production Deployment Checklist
- [ ] Update database credentials
- [ ] Enable HTTPS
- [ ] Configure CDN
- [ ] Set up monitoring
- [ ] Configure backups
- [ ] Set up error logging
- [ ] Configure caching
- [ ] Set up SSL certificates
- [ ] Configure firewall rules
- [ ] Set up DMCA procedures

## Troubleshooting
- Check PHP error logs
- Verify database connection
- Ensure file permissions are correct
- Check web server configuration
- Verify .htaccess is working

## Support
For technical support, please contact the development team.
