# Password Reset System - CodeIgniter 3

## Fitur
- Reset password dengan email verifikasi
- Token security dengan expiry time 1 jam
- SMTP Gmail integration
- Validasi password minimal 6 karakter
- Password terenkripsi dengan bcrypt
- UI responsive dengan Tailwind CSS

## Instalasi

### 1. Setup Database
Jalankan query SQL untuk membuat tabel password_resets:
```sql
-- Jalankan file: sql/password_reset_queries.sql
-- atau jalankan migration:
php index.php migrate
```

### 2. Konfigurasi SMTP
Edit file `application/config/email.php`:
```php
$config['smtp_user'] = 'your-email@gmail.com';
$config['smtp_pass'] = 'your-app-password';
```

### 3. Setup Gmail App Password
1. Aktifkan 2FA di akun Gmail
2. Buat App Password di: https://myaccount.google.com/apppasswords
3. Copy password dan paste di `smtp_pass`

### 4. Routes
- Halaman reset password: `/password-reset`
- Form password baru: `/password-reset/reset/[token]`

## Flow Penggunaan

1. **User klik "Change Password"** di halaman profil
2. **Masukkan email** yang terdaftar
3. **Sistem kirim email** dengan link reset
4. **User klik link** di email
5. **Masukkan password baru** (min 6 karakter)
6. **Password tersimpan** terenkripsi di database

## Struktur File

### Controller
- `application/controllers/Password_reset.php` - Handle password reset logic

### Model
- `application/models/Password_reset_model.php` - Database operations
- `application/models/User_model.php` - User management

### Views
- `application/views/auth/password_reset_request.php` - Form email
- `application/views/auth/password_reset_form.php` - Form password baru

### Config
- `application/config/email.php` - SMTP configuration

### Database
- `application/migrations/010_create_password_resets_table.php` - Migration file

## Testing

### Test Email
1. Gunakan email testing: mailtrap.io atau mailhog
2. Update config email untuk testing

### Test Flow
```bash
# Jalankan server
php -S localhost:8000

# Akses halaman
http://localhost:8000/password-reset
```

## Security Features
- Token unik dengan expiry 1 jam
- Password hashing dengan bcrypt
- CSRF protection
- Input validation
- SQL injection prevention

## Troubleshooting

### Email tidak terkirim
- Cek konfigurasi SMTP
- Pastikan app password benar
- Cek firewall/antivirus
- Gunakan port 587 untuk TLS

### Token expired
- Token hanya valid 1 jam
- User bisa request ulang
- Token otomatis dihapus setelah digunakan

### Error database
- Pastikan tabel `password_resets` ada
- Jalankan migration jika belum
- Cek koneksi database
