<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Default Controller (homepage)
$route['default_controller'] = 'home/index';

// Auth Routes
$route['login'] = 'auth/login';
$route['register'] = 'auth/register';
$route['logout'] = 'auth/logout';

// Admin Panel
$route['admin'] = 'admin/index';
$route['admin/dashboard'] = 'admin/index';

$route['admin/videos'] = 'admin/videos';
$route['admin/videos/create'] = 'admin/video_create';
$route['admin/videos/edit/(:num)'] = 'admin/video_edit/$1';
$route['admin/videos/delete/(:num)'] = 'admin/video_delete/$1';

$route['admin/users'] = 'admin/users';
$route['admin/users/view/(:num)'] = 'admin/user_view/$1';
$route['admin/users/edit/(:num)'] = 'admin/user_edit/$1';
$route['admin/users/ban/(:num)'] = 'admin/user_ban/$1';
$route['admin/users/delete/(:num)'] = 'admin/user_delete/$1';

$route['admin/categories'] = 'admin/categories';
$route['admin/categories/create'] = 'admin/category_create';
$route['admin/categories/edit/(:num)'] = 'admin/category_edit/$1';
$route['admin/categories/delete/(:num)'] = 'admin/category_delete/$1';

$route['admin/tags'] = 'admin/tags';
$route['admin/tags/create'] = 'admin/tag_create';
$route['admin/tags/edit/(:num)'] = 'admin/tag_edit/$1';
$route['admin/tags/delete/(:num)'] = 'admin/tag_delete/$1';

// 404 & URI Translation
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

$route['password-reset'] = 'password_reset/index';
$route['password-reset/request'] = 'password_reset/request';
$route['password-reset/reset/(:any)'] = 'password_reset/reset/$1';
$route['password-reset/update'] = 'password_reset/update';
