<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

    public function index() {
        $this->load->model('Video_model');
        $this->load->model('Category_model');

        $data['categories'] = $this->Category_model->get_all_active();
        $data['videos'] = $this->Video_model->get_published_videos_with_categories_tags();

        $this->load->view('home', $data);
    }

    public function watch($id = null) {
        if (!$id) {
            show_404();
            return;
        }

        $this->load->model('Video_model');
        $this->load->model('Category_model');
        $this->load->model('Banner_model');

        $video = $this->Video_model->get_video_by_id($id);
        if (!$video) {
            show_404();
            return;
        }

        $category_id = null;
        if (isset($video->categories) && !empty($video->categories)) {
            $category_id = $video->categories[0]->id;
        }

        $related_videos = [];
        if ($category_id !== null) {
            $related_videos = $this->Video_model->get_related_videos($category_id, $video->id, 12);
        } else {
            $related_videos = $this->Video_model->get_related_videos_without_category($video->id, 12);
        }

        // Load active banners for display
        $banners = $this->Banner_model->get_active_banners();

        // Load comments and like status for the current user
        $this->load->library('session');
        $user_id = $this->session->userdata('user_id');
        $user_liked = false;
        if ($user_id) {
            $user_liked = $this->Video_model->user_liked_video($id, $user_id);
        }
        $likes_count = $this->Video_model->get_likes_count($id);
        $comments = $this->Video_model->get_video_comments($id);

        $data['video'] = $video;
        $data['related_videos'] = $related_videos;
        $data['categories'] = $this->Category_model->get_all_active();
        $data['user_liked'] = $user_liked;
        $data['likes_count'] = $likes_count;
        $data['comments'] = $comments;
        $data['banners'] = $banners;

        $this->load->view('watch', $data);
    }

    public function like_video() {
        $this->load->model('Video_model');
        $this->load->library('session');
        $user_id = $this->session->userdata('user_id');
        if (!$user_id) {
            echo json_encode(['success' => false, 'message' => 'User not logged in']);
            return;
        }
        $video_id = $this->input->post('video_id');
        $action = $this->input->post('action'); // 'like' or 'unlike'

        if ($action === 'like') {
            $result = $this->Video_model->add_like($video_id, $user_id);
        } elseif ($action === 'unlike') {
            $result = $this->Video_model->remove_like($video_id, $user_id);
        } else {
            $result = false;
        }

        if ($result) {
            $likes_count = $this->Video_model->get_likes_count($video_id);
            echo json_encode(['success' => true, 'likes_count' => $likes_count]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Action failed']);
        }
    }

    public function post_comment() {
        $this->load->model('Video_model');
        $this->load->library('session');
        $user_id = $this->session->userdata('user_id');
        if (!$user_id) {
            echo json_encode(['success' => false, 'message' => 'User not logged in']);
            return;
        }
        $video_id = $this->input->post('video_id');
        $content = $this->input->post('content');

        if (empty($content)) {
            echo json_encode(['success' => false, 'message' => 'Comment content cannot be empty']);
            return;
        }

        $data = [
            'video_id' => $video_id,
            'user_id' => $user_id,
            'content' => $content,
            'status' => 'pending',
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        ];

        $inserted = $this->db->insert('comments', $data);

        if ($inserted) {
            echo json_encode(['success' => true, 'message' => 'Comment submitted for approval']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to submit comment']);
        }
    }
}
