<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Video_model');
        $this->load->model('Category_model');
        $this->load->model('User_model');
        $this->load->library('session');
        
        // Cek login
        if (!$this->session->userdata('user_id')) {
            redirect('auth/login');
        }
    }

    public function index() {
        $data['grouped_videos'] = $this->Video_model->get_videos_grouped_by_category(10);
        $data['categories'] = $this->Category_model->get_all_active();
        $data['user'] = $this->session->userdata();
        
        $this->load->view('user_dashboard', $data);
    }

    public function profile() {
        $user_id = $this->session->userdata('user_id');
        $data['user'] = $this->User_model->get_user($user_id);
        $data['categories'] = $this->Category_model->get_all_active();
        
        $this->load->view('user_profile', $data);
    }

    public function update_profile() {
        $user_id = $this->session->userdata('user_id');
        $this->load->library('form_validation');
        $this->load->library('upload');

        $this->form_validation->set_rules('full_name', 'Full Name', 'trim|required');
        $this->form_validation->set_rules('nick_name', 'Username', 'trim|required');
        $this->form_validation->set_rules('gender', 'Gender', 'trim');
        $this->form_validation->set_rules('country', 'Country', 'trim');
        $this->form_validation->set_rules('date_of_birth', 'Date of Birth', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('error', validation_errors());
            redirect('user/profile');
        } else {
            $data = [
                'full_name' => $this->input->post('full_name'),
                'user_name' => $this->input->post('nick_name'),
                'gender' => $this->input->post('gender'),
                'country' => $this->input->post('country'),
                'date_of_birth' => $this->input->post('date_of_birth'),
                'updated_at' => date('Y-m-d H:i:s')
            ];

            // Handle profile image upload
            if (!empty($_FILES['profile_image']['name'])) {
                $upload_path = './assets/uploads/profile_images/';
                if (!is_dir($upload_path)) {
                    mkdir($upload_path, 0755, true);
                }

                $config['upload_path'] = $upload_path;
                $config['allowed_types'] = 'gif|jpg|jpeg|png';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'profile_' . $user_id . '_' . time();

                $this->upload->initialize($config);

                if ($this->upload->do_upload('profile_image')) {
                    $upload_data = $this->upload->data();
                    $data['profile_image'] = 'assets/uploads/profile_images/' . $upload_data['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('user/profile');
                }
            }

            $updated = $this->User_model->update_user($user_id, $data);

            if ($updated) {
                // Update session profile_image if changed
                if (isset($data['profile_image'])) {
                    $this->session->set_userdata('profile_image', $data['profile_image']);
                }
                $this->session->set_flashdata('success', 'Profile updated successfully.');
            } else {
                $this->session->set_flashdata('error', 'Failed to update profile.');
            }
            redirect('user/profile');
        }
    }
}
