<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('resize_banner')) {
    /**
     * Resize banner image to 728x90 while maintaining aspect ratio
     * 
     * @param string $image_path Path to the image
     * @param int $width Target width (default: 728)
     * @param int $height Target height (default: 90)
     * @return string HTML img tag with proper styling
     */
    function resize_banner($image_path, $width = 728, $height = 90, $alt = 'Banner') {
        $CI =& get_instance();
        $full_path = 'uploads/banners/' . $image_path;
        
        if (!file_exists(FCPATH . $full_path)) {
            return '<img src="' . base_url('assets/images/no-banner.jpg') . '" 
                         alt="' . $alt . '" 
                         style="width: ' . $width . 'px; height: ' . $height . 'px; object-fit: contain;">';
        }
        
        return '<img src="' . base_url($full_path) . '" 
                     alt="' . $alt . '" 
                     style="width: ' . $width . 'px; height: ' . $height . 'px; object-fit: contain; max-width: 100%;">';
    }
}

if (!function_exists('get_responsive_banner_style')) {
    /**
     * Get responsive CSS style for banner container
     * 
     * @param int $max_width Maximum container width
     * @return string CSS style
     */
    function get_responsive_banner_style($max_width = 728) {
        return '
            .banner-container {
                max-width: ' . $max_width . 'px;
                margin: 0 auto;
                position: relative;
            }
            .banner-image {
                width: 100%;
                height: auto;
                max-height: 90px;
                object-fit: contain;
                border-radius: 0.5rem;
            }
            @media (max-width: 768px) {
                .banner-image {
                    max-height: 60px;
                }
            }
            @media (max-width: 480px) {
                .banner-image {
                    max-height: 50px;
                }
            }
        ';
    }
}

if (!function_exists('generate_banner_html')) {
    /**
     * Generate HTML for banner with responsive sizing
     * 
     * @param array $banner Banner data
     * @param array $options Additional options
     * @return string HTML
     */
    function generate_banner_html($banner, $options = []) {
        $width = $options['width'] ?? 728;
        $height = $options['height'] ?? 90;
        $class = $options['class'] ?? '';
        $link = $banner->link_url ?? '';
        
        $img_html = '<img src="' . base_url('uploads/banners/' . $banner->image_path) . '" 
                           alt="' . htmlspecialchars($banner->title) . '" 
                           class="banner-image ' . $class . '"
                           style="width: ' . $width . 'px; height: ' . $height . 'px; object-fit: contain;">';
        
        if ($link) {
            return '<a href="' . $link . '" target="_blank" rel="noopener noreferrer">' . $img_html . '</a>';
        }
        
        return $img_html;
    }
}

if (!function_exists('display_desktop_banner_left_right')) {
    /**
     * Display desktop banner layout with left-right positioning
     * Khusus untuk desktop view (1024px ke atas)
     * 
     * @param array $banners Array of banner objects
     * @param string $main_content HTML content untuk area utama
     * @return string HTML
     */
    function display_desktop_banner_left_right($banners, $main_content = '') {
        $CI =& get_instance();
        
        // Pastikan ada minimal 2 banner untuk layout kiri-kanan
        if (empty($banners) || count($banners) < 2) {
            // Fallback ke banner display biasa jika kurang dari 2 banner
            return $CI->load->view('templates/banner_display', ['banners' => $banners], true);
        }
        
        return $CI->load->view('templates/desktop_banner_left_right', [
            'banners' => $banners,
            'main_content' => $main_content
        ], true);
    }
}
