<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_video_likes_table extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'video_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
            ),
            'user_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
            ),
            'created_at' => array(
                'type' => 'DATETIME',
                'null' => FALSE,
                'default' => 'CURRENT_TIMESTAMP'
            )
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key(array('video_id', 'user_id'));
        $this->dbforge->create_table('video_likes');

        // Add foreign keys
        $this->db->query('ALTER TABLE `video_likes` ADD CONSTRAINT `fk_video_likes_video` FOREIGN KEY (`video_id`) REFERENCES `videos`(`id`) ON DELETE CASCADE');
        $this->db->query('ALTER TABLE `video_likes` ADD CONSTRAINT `fk_video_likes_user` FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE');
    }

    public function down() {
        $this->dbforge->drop_table('video_likes');
    }
}
