<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Add_gender_to_users extends CI_Migration {

    public function up() {
        // Add gender column to users table
        $fields = array(
            'gender' => array(
                'type' => 'ENUM',
                'constraint' => array('male', 'female', 'other'),
                'null' => TRUE,
                'default' => NULL
            )
        );
        $this->dbforge->add_column('users', $fields);
    }

    public function down() {
        // Remove gender column from users table
        $this->dbforge->drop_column('users', 'gender');
    }
}
