<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Add_profile_fields_to_users extends CI_Migration {

    public function up() {
        // Add missing profile fields
        $fields = array(
            'full_name' => array(
                'type' => 'VARCHAR',
                'constraint' => '200',
                'null' => TRUE,
                'default' => NULL
            ),
            'nick_name' => array(
                'type' => 'VARCHAR',
                'constraint' => '100',
                'null' => TRUE,
                'default' => NULL
            ),
            'date_of_birth' => array(
                'type' => 'DATE',
                'null' => TRUE,
                'default' => NULL
            )
        );
        $this->dbforge->add_column('users', $fields);
    }

    public function down() {
        // Remove profile fields
        $this->dbforge->drop_column('users', 'full_name');
        $this->dbforge->drop_column('users', 'nick_name');
        $this->dbforge->drop_column('users', 'date_of_birth');
    }
}
