<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_add_banner_tracking extends CI_Migration {

    public function up()
    {
        // Add expires_at and clicks_count columns to banners table
        $fields = array(
            'expires_at' => array(
                'type' => 'DATETIME',
                'null' => TRUE,
                'after' => 'created_at'
            ),
            'clicks_count' => array(
                'type' => 'INT',
                'constraint' => 11,
                'default' => 0,
                'null' => FALSE,
                'after' => 'expires_at'
            )
        );
        $this->dbforge->add_column('banners', $fields);

        // Create banner_clicks table for detailed click tracking
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'banner_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'null' => FALSE
            ),
            'clicked_at' => array(
                'type' => 'DATETIME',
                'null' => FALSE
            ),
            'user_ip' => array(
                'type' => 'VARCHAR',
                'constraint' => 45,
                'null' => TRUE
            )
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('banner_clicks');
    }

    public function down()
    {
        $this->dbforge->drop_column('banners', 'expires_at');
        $this->dbforge->drop_column('banners', 'clicks_count');
        $this->dbforge->drop_table('banner_clicks');
    }
}
