<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_010_create_password_resets_table extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'email' => array(
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => FALSE
            ),
            'token' => array(
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => FALSE
            ),
            'created_at' => array(
                'type' => 'DATETIME',
                'null' => FALSE
            ),
            'expires_at' => array(
                'type' => 'DATETIME',
                'null' => FALSE
            ),
            'used' => array(
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0
            )
        ));
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key('email');
        $this->dbforge->add_key('token');
        $this->dbforge->create_table('password_resets');
    }

    public function down() {
        $this->dbforge->drop_table('password_resets');
    }
}
