<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Category_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * Get all categories
     */
    public function get_all() {
        return $this->db->order_by('parent_id', 'ASC')->order_by('name', 'ASC')->get('categories')->result();
    }

    /**
     * Get all active categories
     */
    public function get_all_active() {
        return $this->db->where('is_active', TRUE)->order_by('parent_id', 'ASC')->order_by('name', 'ASC')->get('categories')->result();
    }

    /**
     * Get category by ID
     */
    public function get($id) {
        return $this->db->where('id', $id)->get('categories')->row();
    }

    /**
     * Insert new category
     */
    public function insert($data) {
        return $this->db->insert('categories', $data);
    }

    /**
     * Update category
     */
    public function update($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('categories', $data);
    }

    /**
     * Delete category
     */
    public function delete($id) {
        return $this->db->where('id', $id)->delete('categories');
    }

    /**
     * Get parent category by child category ID
     */
    public function get_parent_category($category_id) {
        $category = $this->get($category_id);
        if ($category && $category->parent_id) {
            return $this->get($category->parent_id);
        }
        return null;
    }
}
