<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tag_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function get_all() {
        return $this->db->order_by('name', 'ASC')->get('tags')->result();
    }

    public function get($id) {
        return $this->db->where('id', $id)->get('tags')->row();
    }

    public function get_by_name($name) {
        return $this->db->where('name', $name)->get('tags')->row();
    }

    public function insert($data) {
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->insert('tags', $data);
        return $this->db->insert_id();
    }

    public function update($id, $data) {
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->where('id', $id)->update('tags', $data);
        return $this->db->affected_rows() > 0;
    }

    public function delete($id) {
        $this->db->where('id', $id)->delete('tags');
        return $this->db->affected_rows() > 0;
    }
}
