<?php
/**
 * Admin Dashboard - Banner Clicks Table
 * Displays banner table with click tracking data
 */
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Banner Management</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="bannerTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Judul Banner</th>
                                    <th>Tanggal Posting</th>
                                    <th>Tanggal Habis Aktif</th>
                                    <th>Jumlah Klik</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($banners)): ?>
                                    <?php foreach ($banners as $banner): ?>
                                        <tr>
                                            <td><?= $banner->id ?></td>
                                            <td><?= htmlspecialchars($banner->title) ?></td>
                                            <td><?= date('d/m/Y H:i', strtotime($banner->created_at)) ?></td>
                                            <td>
                                                <?php if ($banner->expires_at): ?>
                                                    <?= date('d/m/Y H:i', strtotime($banner->expires_at)) ?>
                                                <?php else: ?>
                                                    <span class="text-muted">Tidak ada</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <span class="badge badge-primary"><?= $banner->total_clicks ?></span>
                                            </td>
                                            <td>
                                                <span class="badge badge-<?= $banner->status == 'active' ? 'success' : 'secondary' ?>">
                                                    <?= ucfirst($banner->status) ?>
                                                </span>
                                            </td>
                                            <td>
                                                <a href="<?= site_url('admin/banner/edit/' . $banner->id) ?>" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-edit"></i> Edit
                                                </a>
                                                <a href="<?= site_url('admin/banner/delete/' . $banner->id) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                    <i class="fas fa-trash"></i> Delete
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="7" class="text-center">No banners found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#bannerTable').DataTable({
        responsive: true,
        order: [[4, 'desc']] // Sort by clicks count descending
    });
});
</script>
