<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Admin - <?= isset($banner) ? 'Edit Banner' : 'Add New Banner' ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-900 text-white min-h-screen flex flex-col">
    <header class="bg-gray-800 p-4 shadow-md">
        <div class="container mx-auto flex justify-between items-center">
            <h1 class="text-3xl font-bold">Admin Dashboard</h1>
            <nav>
                <a href="<?php echo site_url('admin/videos'); ?>" class="px-3 py-2 hover:text-yellow-400">Videos</a>
                <a href="<?php echo site_url('admin/users'); ?>" class="px-3 py-2 hover:text-yellow-400">Users</a>
                <a href="<?php echo site_url('admin/banners'); ?>" class="px-3 py-2 hover:text-yellow-400 font-bold underline">Banners</a>
                <a href="<?php echo site_url('admin/categories'); ?>" class="px-3 py-2 hover:text-yellow-400">Categories</a>
                <a href="<?php echo site_url('admin/tags'); ?>" class="px-3 py-2 hover:text-yellow-400">Tags</a>
                <a href="<?php echo site_url('auth/logout'); ?>" class="px-3 py-2 hover:text-yellow-400">Logout</a>
            </nav>
        </div>
    </header>
    <main class="flex-grow container mx-auto p-6">
        <section>
            <h2 class="text-2xl font-semibold mb-4"><?= isset($banner) ? 'Edit Banner' : 'Add New Banner' ?></h2>

            <?php if ($this->session->flashdata('success')): ?>
                <div class="bg-green-600 text-white p-3 rounded mb-4">
                    <?= $this->session->flashdata('success') ?>
                </div>
            <?php endif; ?>

            <?php if (isset($error)): ?>
                <div class="bg-red-600 text-white p-3 rounded mb-4">
                    <?= $error ?>
                </div>
            <?php endif; ?>

            <form method="post" enctype="multipart/form-data" class="space-y-6 max-w-lg">
                <div>
                    <label for="title" class="block mb-1 font-semibold">Title *</label>
                    <input type="text" id="title" name="title" required
                           value="<?= isset($banner) ? html_escape($banner->title) : '' ?>"
                           class="w-full p-2 rounded bg-gray-700 text-white border border-gray-600 focus:outline-none focus:border-yellow-500" />
                </div>

                <div>
                    <label for="banner_image" class="block mb-1 font-semibold">Banner Image <?= isset($banner) ? '' : '*' ?></label>
                    <input type="file" id="banner_image" name="banner_image" <?= isset($banner) ? '' : 'required' ?>
                           class="w-full p-2 rounded bg-gray-700 text-white border border-gray-600 focus:outline-none focus:border-yellow-500" />
                    <p class="text-gray-400 text-sm mt-1">Max size: 2MB, Allowed types: JPG, JPEG, PNG, GIF. Recommended size: 728x90 px.</p>
                    <?php if (isset($banner) && $banner->image_path): ?>
                        <img src="<?= base_url('uploads/banners/' . $banner->image_path) ?>" alt="Current banner" class="mt-2 max-w-xs rounded" />
                    <?php endif; ?>
                </div>

                <div>
                    <label for="link_url" class="block mb-1 font-semibold">Link URL</label>
                    <input type="url" id="link_url" name="link_url"
                           value="<?= isset($banner) ? html_escape($banner->link_url) : '' ?>"
                           placeholder="https://example.com"
                           class="w-full p-2 rounded bg-gray-700 text-white border border-gray-600 focus:outline-none focus:border-yellow-500" />
                    <p class="text-gray-400 text-sm mt-1">Optional: URL where users will be redirected when clicking the banner.</p>
                </div>

                <div>
                    <label for="status" class="block mb-1 font-semibold">Status *</label>
                    <select id="status" name="status" required
                            class="w-full p-2 rounded bg-gray-700 text-white border border-gray-600 focus:outline-none focus:border-yellow-500">
                        <option value="active" <?= isset($banner) && $banner->status == 'active' ? 'selected' : '' ?>>Active</option>
                        <option value="inactive" <?= isset($banner) && $banner->status == 'inactive' ? 'selected' : '' ?>>Inactive</option>
                    </select>
                </div>

                <div>
                    <label for="sort_order" class="block mb-1 font-semibold">Sort Order</label>
                    <input type="number" id="sort_order" name="sort_order" min="0"
                           value="<?= isset($banner) ? $banner->sort_order : '0' ?>"
                           class="w-full p-2 rounded bg-gray-700 text-white border border-gray-600 focus:outline-none focus:border-yellow-500" />
                    <p class="text-gray-400 text-sm mt-1">Lower numbers appear first. Default is 0.</p>
                </div>

                <div>
                    <label for="expires_at" class="block mb-1 font-semibold">Tanggal Habis Aktif</label>
                    <input type="datetime-local" id="expires_at" name="expires_at"
                           value="<?= isset($banner) && isset($banner->expires_at) && $banner->expires_at ? date('Y-m-d\TH:i', strtotime($banner->expires_at)) : '' ?>"
                           class="w-full p-2 rounded bg-gray-700 text-white border border-gray-600 focus:outline-none focus:border-yellow-500" />
                    <p class="text-gray-400 text-sm mt-1">Optional: Date and time when the banner expires.</p>
                </div>

                <div class="flex space-x-4">
                    <button type="submit" class="bg-yellow-500 hover:bg-yellow-600 text-black px-4 py-2 rounded font-semibold">
                        <?= isset($banner) ? 'Update Banner' : 'Create Banner' ?>
                    </button>
                    <a href="<?= site_url('admin/banners') ?>" class="bg-gray-700 hover:bg-gray-600 text-white px-4 py-2 rounded font-semibold">
                        Cancel
                    </a>
                </div>
            </form>
        </section>
    </main>

    <footer class="bg-gray-800 p-4 text-center text-gray-400">
        &copy; 2025 Klimaks.com Admin Panel
    </footer>
</body>
</html>
