<?php
/**
 * Admin Dashboard - Banner Statistics
 * Displays detailed statistics for a specific banner
 */
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <title>Banner Statistics - Admin Dashboard</title>
    
    <!-- Custom fonts for this template -->
    <link href="<?= base_url('assets/sbadmin2/vendor/fontawesome-free/css/all.min.css') ?>" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    
    <!-- Custom styles for this template -->
    <link href="<?= base_url('assets/sbadmin2/css/sb-admin-2.min.css') ?>" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<body id="page-top">
    <!-- Page Wrapper -->
    <div id="wrapper">
        <!-- Sidebar -->
        <?php $this->load->view('admin/templates/sidebar'); ?>
        
        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">
            <!-- Main Content -->
            <div id="content">
                <!-- Topbar -->
                <?php $this->load->view('admin/templates/topbar'); ?>
                
                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Banner Statistics</h1>
                        <a href="<?= site_url('admin/banners') ?>" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                            <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Banners
                        </a>
                    </div>

                    <!-- Banner Info Card -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">Banner Details</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Title:</strong> <?= htmlspecialchars($banner->title) ?></p>
                                            <p><strong>Status:</strong> 
                                                <span class="badge badge-<?= $banner->status == 'active' ? 'success' : 'secondary' ?>">
                                                    <?= ucfirst($banner->status) ?>
                                                </span>
                                            </p>
                                            <p><strong>Created:</strong> <?= date('d/m/Y H:i', strtotime($banner->created_at)) ?></p>
                                            <?php if ($banner->expires_at): ?>
                                                <p><strong>Expires:</strong> <?= date('d/m/Y H:i', strtotime($banner->expires_at)) ?></p>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Total Clicks:</strong> <span class="text-primary font-weight-bold"><?= $banner->clicks_count ?></span></p>
                                            <p><strong>Link URL:</strong> 
                                                <a href="<?= $banner->link_url ?>" target="_blank"><?= $banner->link_url ?></a>
                                            </p>
                                            <p><strong>Sort Order:</strong> <?= $banner->sort_order ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Clicks Chart -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">Clicks Over Time</h6>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container" style="position: relative; height:300px;">
                                        <canvas id="clicksChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Clicks Table -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">Daily Clicks</h6>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered" id="clicksTable" width="100%" cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Clicks</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if (!empty($clicks_by_date)): ?>
                                                    <?php foreach ($clicks_by_date as $click): ?>
                                                        <tr>
                                                            <td><?= date('d/m/Y', strtotime($click->click_date)) ?></td>
                                                            <td><?= $click->click_count ?></td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td colspan="2" class="text-center">No clicks recorded</td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            
            <!-- Footer -->
            <?php $this->load->view('admin/templates/footer'); ?>
        </div>
                <!-- End of Content Wrapper -->
            </div>
            <!-- End of Page Wrapper -->
            
            <!-- Scroll to Top Button-->
            <a class="scroll-to-top rounded" href="#page-top">
                <i class="fas fa-angle-up"></i>
            </a>
            
            <!-- Bootstrap core JavaScript-->
            <script src="<?= base_url('assets/sbadmin2/vendor/jquery/jquery.min.js') ?>"></script>
            <script src="<?= base_url('assets/sbadmin2/vendor/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>
            
            <!-- Core plugin JavaScript-->
            <script src="<?= base_url('assets/sbadmin2/vendor/jquery-easing/jquery.easing.min.js') ?>"></script>
            
            <!-- Custom scripts for all pages-->
            <script src="<?= base_url('assets/sbadmin2/js/sb-admin-2.min.js') ?>"></script>
            
            <!-- Page level plugins -->
            <script src="<?= base_url('assets/sbadmin2/vendor/datatables/jquery.dataTables.min.js') ?>"></script>
            <script src="<?= base_url('assets/sbadmin2/vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>
            
            <script>
            $(document).ready(function() {
                $('#clicksTable').DataTable({
                    responsive: true,
                    order: [[0, 'desc']]
                });
            });
            </script>
</body>
</html>
