<?php
/**
 * Admin Dashboard - Banners Management
 * Displays banner table with click tracking data
 */
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <title>Banner Management - Admin Dashboard</title>
    
    <!-- Custom fonts for this template -->
    <link href="<?= base_url('assets/sbadmin2/vendor/fontawesome-free/css/all.min.css') ?>" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    
    <!-- Custom styles for this template -->
    <link href="<?= base_url('assets/sbadmin2/css/sb-admin-2.min.css') ?>" rel="stylesheet">
    
    <!-- Custom styles for this page -->
    <link href="<?= base_url('assets/sbadmin2/vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
</head>

<body id="page-top">
    <!-- Page Wrapper -->
    <div id="wrapper">
        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">
            <!-- Main Content -->
            <div id="content">
                
                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Banner Management</h1>
                        <a href="<?= site_url('admin/banner_create') ?>" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
                            <i class="fas fa-plus fa-sm text-white-50"></i> Add New Banner
                        </a>
                    </div>

                    <!-- Content Row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">Banner List</h6>
                                </div>
                                <div class="card-body">
                                    <?php if ($this->session->flashdata('success')): ?>
                                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                                            <?= $this->session->flashdata('success') ?>
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="table-responsive">
                                        <table class="table table-bordered" id="bannerTable" width="100%" cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Judul Banner</th>
                                                    <th>Tanggal Posting</th>
                                                    <th>Tanggal Habis Aktif</th>
                                                    <th>Jumlah Klik</th>
                                                    <th>Status</th>
                                                    <th>Aksi</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if (!empty($banners)): ?>
                                                    <?php foreach ($banners as $banner): ?>
                                                        <tr>
                                                            <td><?= $banner->id ?></td>
                                                            <td><?= htmlspecialchars($banner->title) ?></td>
                                                            <td><?= date('d/m/Y H:i', strtotime($banner->created_at)) ?></td>
                                                            <td>
                                                                <?php if (isset($banner->expires_at) && $banner->expires_at): ?>
                                                                    <?= date('d/m/Y H:i', strtotime($banner->expires_at)) ?>
                                                                <?php else: ?>
                                                                    <span class="text-muted">Tidak ada</span>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td>
                                                                <span class="badge badge-primary"><?= $banner->total_clicks ?></span>
                                                            </td>
                                                            <td>
                                                                <span class="badge badge-<?= $banner->status == 'active' ? 'success' : 'secondary' ?>">
                                                                    <?= ucfirst($banner->status) ?>
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <a href="<?= site_url('admin/banner_edit/' . $banner->id) ?>" class="btn btn-sm btn-warning">
                                                                    <i class="fas fa-edit"></i> Edit
                                                                </a>
                                                                <a href="<?= site_url('admin/banner_delete/' . $banner->id) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                                    <i class="fas fa-trash"></i> Delete
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td colspan="7" class="text-center">No banners found</td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <?php if (!empty($pagination_links)): ?>
                                        <div class="mt-3">
                                            <?= $pagination_links ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            
            <!-- Footer -->
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->
    
    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>
    
    <!-- Bootstrap core JavaScript-->
    <script src="<?= base_url('assets/sbadmin2/vendor/jquery/jquery.min.js') ?>"></script>
    <script src="<?= base_url('assets/sbadmin2/vendor/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>
    
    <!-- Core plugin JavaScript-->
    <script src="<?= base_url('assets/sbadmin2/vendor/jquery-easing/jquery.easing.min.js') ?>"></script>
    
    <!-- Custom scripts for all pages-->
    <script src="<?= base_url('assets/sbadmin2/js/sb-admin-2.min.js') ?>"></script>
    
    <!-- Page level plugins -->
    <script src="<?= base_url('assets/sbadmin2/vendor/datatables/jquery.dataTables.min.js') ?>"></script>
    <script src="<?= base_url('assets/sbadmin2/vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>
    
    <!-- Page level custom scripts -->
    <script>
    $(document).ready(function() {
        $('#bannerTable').DataTable({
            responsive: true,
            order: [[4, 'desc']] // Sort by clicks count descending
        });
    });
    </script>
</body>
</html>
