<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Klimaks - Streaming Bokep No.1</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-900 text-white min-h-screen p-6">
    <h1 class="text-3xl font-bold mb-4">Manage Categories</h1>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="bg-green-600 p-2 mb-4 rounded">
            <?php echo $this->session->flashdata('success'); ?>
        </div>
    <?php endif; ?>

    <a href="<?php echo site_url('admin/category_create'); ?>" class="bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-bold py-2 px-4 rounded mb-4 inline-block">Add New Category</a>

    <?php if (empty($categories)): ?>
        <p>No categories found.</p>
    <?php else: ?>
        <table class="w-full table-auto border-collapse border border-gray-700">
            <thead>
                <tr class="bg-gray-800">
                    <th class="border border-gray-600 px-4 py-2">ID</th>
                    <th class="border border-gray-600 px-4 py-2">Name</th>
                    <th class="border border-gray-600 px-4 py-2">Parent ID</th>
                    <th class="border border-gray-600 px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($categories as $category): ?>
                    <tr>
                        <td class="border border-gray-600 px-4 py-2"><?php echo $category->id; ?></td>
                        <td class="border border-gray-600 px-4 py-2"><?php echo htmlspecialchars($category->name); ?></td>
                        <td class="border border-gray-600 px-4 py-2"><?php echo $category->parent_id ?: '-'; ?></td>
                        <td class="border border-gray-600 px-4 py-2">
                            <a href="<?php echo site_url('admin/category_edit/'.$category->id); ?>" class="text-yellow-400 hover:underline mr-2">Edit</a>
                            <a href="<?php echo site_url('admin/category_delete/'.$category->id); ?>" class="text-red-600 hover:underline" onclick="return confirm('Are you sure you want to delete this category?');">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</body>
</html>
