<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Klimaks - Streaming Bokep No.1</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-900 text-white min-h-screen p-6">
    <h1 class="text-3xl font-bold mb-4"><?php echo isset($category) ? 'Edit Category' : 'Create Category'; ?></h1>

    <?php echo validation_errors('<div class="bg-red-600 p-2 mb-4 rounded">', '</div>'); ?>

    <?php echo form_open(isset($category) ? 'admin/category_edit/'.$category->id : 'admin/category_create'); ?>

    <div class="mb-4">
        <label class="block mb-1" for="name">Name</label>
        <input type="text" name="name" id="name" value="<?php echo set_value('name', isset($category) ? $category->name : ''); ?>" class="w-full p-2 rounded text-gray-900" required />
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="parent_id">Parent Category</label>
        <select name="parent_id" id="parent_id" class="w-full p-2 rounded text-gray-900">
            <option value="">None</option>
            <?php
            if (isset($categories)) {
                foreach ($categories as $cat) {
                    $selected = (isset($category) && $category->parent_id == $cat->id) ? 'selected' : '';
                    echo "<option value=\"{$cat->id}\" $selected>{$cat->name}</option>";
                }
            }
            ?>
        </select>
    </div>

    <button type="submit" class="bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-bold py-2 px-4 rounded">
        <?php echo isset($category) ? 'Update Category' : 'Create Category'; ?>
    </button>

    <?php echo form_close(); ?>
</body>
</html>
