<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Klimaks - Streaming Bokep No.1</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
        }
        .modal-content {
            background-color: #1f2937;
            margin: 5% auto;
            padding: 20px;
            border-radius: 8px;
            width: 80%;
            max-width: 600px;
            max-height: 80vh;
            overflow-y: auto;
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        .close:hover {
            color: #fff;
        }
    </style>
</head>
<body class="bg-gray-900 text-white min-h-screen flex flex-col">
    <header class="bg-gray-800 p-4 shadow-md">
        <div class="container mx-auto flex justify-between items-center">
            <h1 class="text-3xl font-bold">Admin Dashboard</h1>
            <nav>
                <a href="<?php echo site_url('admin/videos'); ?>" class="px-3 py-2 hover:text-yellow-400">Videos</a>
                <a href="<?php echo site_url('admin/users'); ?>" class="px-3 py-2 hover:text-yellow-400">Users</a>
                <a href="<?php echo site_url('admin/banners'); ?>" class="px-3 py-2 hover:text-yellow-400">Banners</a>
                <a href="<?php echo site_url('admin/categories'); ?>" class="px-3 py-2 hover:text-yellow-400">Categories</a>
                <a href="<?php echo site_url('admin/tags'); ?>" class="px-3 py-2 hover:text-yellow-400">Tags</a>
                <a href="<?php echo site_url('auth/logout'); ?>" class="px-3 py-2 hover:text-yellow-400">Logout</a>
            </nav>
        </div>
    </header>
    <main class="flex-grow container mx-auto p-6">
        <section>
            <h2 class="text-2xl font-semibold mb-4">Admin Dashboard</h2>
            
            <!-- User Data Table -->
            <div class="bg-gray-800 rounded-lg shadow-lg p-6 mb-8">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-xl font-semibold">Data Pengguna</h3>
                    <div class="flex items-center space-x-4">
                        <input type="text" id="searchInput" placeholder="Cari username atau email..." 
                               class="px-3 py-2 bg-gray-700 border border-gray-600 rounded text-sm text-white focus:outline-none focus:border-blue-500"
                               value="<?php echo htmlspecialchars($this->input->get('search') ?? ''); ?>">
                        <button onclick="searchUsers()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded text-sm">
                            Cari
                        </button>
                    </div>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full text-sm text-left">
                        <thead class="text-xs uppercase bg-gray-700">
                            <tr>
                                <th class="px-6 py-3">Username</th>
                                <th class="px-6 py-3">Email</th>
                                <th class="px-6 py-3">Login Terakhir</th>
                                <th class="px-6 py-3">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($users)): ?>
                                <tr class="border-b border-gray-700">
                                    <td colspan="4" class="px-6 py-4 text-center">No users found</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($users as $user): ?>
                                    <tr class="border-b border-gray-700 hover:bg-gray-700">
                                        <td class="px-6 py-4 font-medium"><?php echo htmlspecialchars($user->username); ?></td>
                                        <td class="px-6 py-4"><?php echo htmlspecialchars($user->email); ?></td>
                                        <td class="px-6 py-4">
                                            <?php if ($user->last_login): ?>
                                                <?php echo date('d/m/Y H:i', strtotime($user->last_login)); ?>
                                            <?php else: ?>
                                                <span class="text-gray-400">Belum pernah login</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="px-6 py-4">
                                            <button onclick="showLoginHistory(<?php echo $user->id; ?>, '<?php echo addslashes($user->username); ?>')" 
                                                    class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded text-sm">
                                                Login History
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <?php if (!empty($pagination_links)): ?>
                    <div class="mt-4">
                        <?php echo $pagination_links; ?>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Video Statistics Table (Optional - can be kept or removed) -->
            <div class="bg-gray-800 rounded-lg shadow-lg p-6">
                <h3 class="text-xl font-semibold mb-4">Video Statistics</h3>
                
                <div class="overflow-x-auto">
                    <table class="w-full text-sm text-left">
                        <thead class="text-xs uppercase bg-gray-700">
                            <tr>
                                <th class="px-6 py-3">Judul Video</th>
                                <th class="px-6 py-3">Total Penonton</th>
                                <th class="px-6 py-3">Total Like</th>
                                <th class="px-6 py-3">Total Komentar</th>
                                <th class="px-6 py-3">Lihat Komentar</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($video_stats)): ?>
                                <tr class="border-b border-gray-700">
                                    <td colspan="5" class="px-6 py-4 text-center">No videos found</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($video_stats as $video): ?>
                                    <tr class="border-b border-gray-700 hover:bg-gray-700">
                                        <td class="px-6 py-4">
                                            <a href="<?php echo site_url('watch/' . $video->id); ?>" 
                                               class="text-blue-400 hover:text-blue-300 hover:underline" 
                                               target="_blank">
                                                <?php echo htmlspecialchars($video->title); ?>
                                            </a>
                                        </td>
                                        <td class="px-6 py-4"><?php echo number_format($video->views); ?></td>
                                        <td class="px-6 py-4"><?php echo number_format($video->likes); ?></td>
                                        <td class="px-6 py-4"><?php echo number_format($video->total_comments); ?></td>
                                        <td class="px-6 py-4">
                                            <button onclick="showComments(<?php echo $video->id; ?>, '<?php echo addslashes($video->title); ?>')" 
                                                    class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded text-sm">
                                                View
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <?php if (!empty($pagination_links)): ?>
                    <div class="mt-4">
                        <?php echo $pagination_links; ?>
                    </div>
                <?php endif; ?>
            </div>
        </section>
    </main>

    <!-- Comments Modal -->
    <div id="commentsModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeComments()">&times;</span>
            <h3 id="modalTitle" class="text-xl font-semibold mb-4">Comments</h3>
            <div id="commentsList">
                <!-- Comments will be loaded here -->
            </div>
        </div>
    </div>

    <!-- Login History Modal -->
    <div id="loginHistoryModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeLoginHistory()">&times;</span>
            <h3 id="loginHistoryTitle" class="text-xl font-semibold mb-4">Login History</h3>
            <div id="loginHistoryList">
                <!-- Login history will be loaded here -->
            </div>
        </div>
    </div>

    <footer class="bg-gray-800 p-4 text-center text-gray-400">
        &copy; 2025 Klimaks.com Admin Panel
    </footer>

    <script>
        function showComments(videoId, videoTitle) {
            // Show loading
            document.getElementById('commentsList').innerHTML = '<p class="text-center">Loading comments...</p>';
            
            // Set modal title
            document.getElementById('modalTitle').textContent = 'Comments for: ' + videoTitle;
            
            // Show modal
            document.getElementById('commentsModal').style.display = 'block';
            
            // Fetch comments via AJAX
            fetch('<?php echo site_url("admin/get_video_comments/"); ?>' + videoId)
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.comments.length > 0) {
                        let html = '<div class="space-y-4">';
                        data.comments.forEach(comment => {
                            html += `
                                <div class="border-b border-gray-600 pb-3">
                                    <div class="flex justify-between items-start">
                                        <span class="font-semibold text-blue-400">${comment.username}</span>
                                        <span class="text-sm text-gray-400">${comment.created_at}</span>
                                    </div>
                                    <p class="mt-2 text-gray-300">${comment.content}</p>
                                </div>
                            `;
                        });
                        html += '</div>';
                        document.getElementById('commentsList').innerHTML = html;
                    } else {
                        document.getElementById('commentsList').innerHTML = '<p class="text-center text-gray-400">No comments found</p>';
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    document.getElementById('commentsList').innerHTML = '<p class="text-center text-red-400">Error loading comments</p>';
                });
        }

        function closeComments() {
            document.getElementById('commentsModal').style.display = 'none';
        }

        function showLoginHistory(userId, username) {
            // Show loading
            document.getElementById('loginHistoryList').innerHTML = '<p class="text-center">Loading login history...</p>';
            
            // Set modal title
            document.getElementById('loginHistoryTitle').textContent = 'Login History for: ' + username;
            
            // Show modal
            document.getElementById('loginHistoryModal').style.display = 'block';
            
            // Fetch login history via AJAX
            fetch('<?php echo site_url("admin/get_user_login_history/"); ?>' + userId)
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.logins.length > 0) {
                        let html = '<div class="space-y-4">';
                        data.logins.forEach(login => {
                            html += `
                                <div class="border-b border-gray-600 pb-3">
                                    <div class="flex justify-between items-start">
                                        <span class="font-semibold text-blue-400">${login.login_time}</span>
                                        <span class="text-sm text-gray-400">${login.ip_address || 'N/A'}</span>
                                    </div>
                                    <p class="mt-2 text-gray-300">Session: ${login.session_id || 'N/A'}</p>
                                </div>
                            `;
                        });
                        html += '</div>';
                        document.getElementById('loginHistoryList').innerHTML = html;
                    } else {
                        document.getElementById('loginHistoryList').innerHTML = '<p class="text-center text-gray-400">No login history found</p>';
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    document.getElementById('loginHistoryList').innerHTML = '<p class="text-center text-red-400">Error loading login history</p>';
                });
        }

        function closeLoginHistory() {
            document.getElementById('loginHistoryModal').style.display = 'none';
        }

        function searchUsers() {
            const searchValue = document.getElementById('searchInput').value;
            const url = new URL(window.location);
            if (searchValue) {
                url.searchParams.set('search', searchValue);
            } else {
                url.searchParams.delete('search');
            }
            window.location = url;
        }

        // Handle Enter key in search input
        document.getElementById('searchInput').addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                searchUsers();
            }
        });

        // Close modals when clicking outside
        window.onclick = function(event) {
            const commentsModal = document.getElementById('commentsModal');
            const loginHistoryModal = document.getElementById('loginHistoryModal');
            
            if (event.target == commentsModal) {
                commentsModal.style.display = 'none';
            }
            if (event.target == loginHistoryModal) {
                loginHistoryModal.style.display = 'none';
            }
        }
    </script>
</body>
</html>
