<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Klimaks - Streaming Bokep No.1</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-900 text-white min-h-screen p-6">
    <h1 class="text-3xl font-bold mb-4">Manage Tags</h1>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="bg-green-600 p-2 mb-4 rounded">
            <?php echo $this->session->flashdata('success'); ?>
        </div>
    <?php endif; ?>

    <a href="<?php echo site_url('admin/tag_create'); ?>" class="bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-bold py-2 px-4 rounded mb-4 inline-block">Add New Tag</a>

    <?php if (empty($tags)): ?>
        <p>No tags found.</p>
    <?php else: ?>
        <table class="w-full table-auto border-collapse border border-gray-700">
            <thead>
                <tr class="bg-gray-800">
                    <th class="border border-gray-600 px-4 py-2">ID</th>
                    <th class="border border-gray-600 px-4 py-2">Name</th>
                    <th class="border border-gray-600 px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($tags as $tag): ?>
                    <tr>
                        <td class="border border-gray-600 px-4 py-2"><?php echo $tag->id; ?></td>
                        <td class="border border-gray-600 px-4 py-2"><?php echo htmlspecialchars($tag->name); ?></td>
                        <td class="border border-gray-600 px-4 py-2">
                            <a href="<?php echo site_url('admin/tag_edit/'.$tag->id); ?>" class="text-yellow-400 hover:underline mr-2">Edit</a>
                            <a href="<?php echo site_url('admin/tag_delete/'.$tag->id); ?>" class="text-red-600 hover:underline" onclick="return confirm('Are you sure you want to delete this tag?');">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</body>
</html>
