<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Video - Admin</title>
    <link href="<?= base_url('assets/sbadmin2/css/sb-admin-2.min.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets/sbadmin2/vendor/fontawesome-free/css/all.min.css') ?>" rel="stylesheet">
</head>
<body>
    <div class="container-fluid">
        <h1 class="h3 mb-4 text-gray-800">Upload Video</h1>
        
        <?php if($this->session->flashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= $this->session->flashdata('success') ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <?php if($this->session->flashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= $this->session->flashdata('error') ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Upload Video Baru</h6>
            </div>
            <div class="card-body">
                <form action="<?= site_url('admin/video_create') ?>" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="title">Judul Video *</label>
                        <input type="text" class="form-control" id="title" name="title" required>
                    </div>

                    <div class="form-group">
                        <label for="description">Deskripsi *</label>
                        <textarea class="form-control" id="description" name="description" rows="4" required></textarea>
                    </div>

                    <div class="form-group">
                        <label for="video_file">File Video *</label>
                        <input type="file" class="form-control-file" id="video_file" name="video_file" accept="video/*" required>
                        <small class="form-text text-muted">
                            Format yang didukung: MP4, AVI, MOV, WMV, MKV, FLV, WEBM. Maksimal 100MB
                        </small>
                    </div>

                    <div class="form-group">
                        <label for="thumbnail">Thumbnail (Optional)</label>
                        <input type="file" class="form-control-file" id="thumbnail" name="thumbnail" accept="image/*">
                        <small class="form-text text-muted">
                            Format yang didukung: JPG, JPEG, PNG, GIF. Maksimal 2MB
                        </small>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="status">Status *</label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="published">Published</option>
                                    <option value="draft">Draft</option>
                                    <option value="pending">Pending Review</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="visibility">Visibilitas *</label>
                                <select class="form-control" id="visibility" name="visibility" required>
                                    <option value="public">Public</option>
                                    <option value="private">Private</option>
                                    <option value="unlisted">Unlisted</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="categories">Kategori</label>
                                <select multiple class="form-control" id="categories" name="categories[]">
                                    <?php foreach($categories as $category): ?>
                                        <option value="<?= $category->id ?>"><?= $category->name ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="tags">Tags (pisahkan dengan koma)</label>
                                <input type="text" class="form-control" id="tags" name="tags" 
                                       placeholder="contoh: action, adventure, movie">
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> Upload Video
                    </button>
                    <a href="<?= site_url('admin/videos') ?>" class="btn btn-secondary">
                        <i class="fas fa-list"></i> Lihat Daftar Video
                    </a>
                </form>
            </div>
        </div>

        <!-- Informasi Upload Terakhir -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="Saya sudah membaca kode di controller Admin.php dan model Video_model.php yang menangani upload dan penyimpanan video.

Dari controller Admin.php, fungsi upload video (video_create) sudah melakukan:
- Upload file video ke folder uploads/videos dengan konfigurasi yang benar
- Upload thumbnail jika ada
- Menyimpan data video ke database melalui Video_model->insert_video dengan data lengkap termasuk filename dan thumbnail
- Redirect ke halaman daftar video dengan pesan sukses

Dari Video_model.php, fungsi insert_video menyimpan data video ke tabel videos dan juga menyimpan relasi kategori dan tag.

Namun, kemungkinan penyebab video tidak muncul meskipun upload sukses adalah:
- Video tidak muncul di halaman daftar video karena status video tidak "published" (karena query get_videos di model hanya mengambil status 'published')
- Atau ada masalah pada query yang menampilkan video di halaman user/admin

Langkah selanjutnya:
- Cek halaman yang menampilkan video (mungkin di view atau controller lain) dan pastikan query mengambil video dengan status yang sesuai
- Cek apakah status video yang diinput saat upload sudah benar (misal "published")
- Cek apakah file video benar-benar tersimpan di folder uploads/videos
- Cek apakah ada error di log atau di tampilan halaman video

Saya akan lanjut baca file view dan controller yang menampilkan video, misalnya application/views/watch.php dan application/controllers/Home.php untuk melihat bagaimana video ditampilkan.

Mulai dengan baca application/controllers/Home.php:
<read_file>
<path>application/controllers/Home.php</path>
</read_file>
