<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Ban User</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-900 text-white min-h-screen p-6">
    <h1 class="text-3xl font-bold mb-4">Ban User</h1>

    <?php echo form_open(); ?>

    <div class="mb-4">
        <label for="ban_duration" class="block mb-2">Select Ban Duration:</label>
        <select name="ban_duration" id="ban_duration" class="w-full p-2 rounded bg-gray-800 text-white">
            <option value="">-- Select Duration --</option>
            <?php foreach ($ban_durations as $value => $label): ?>
                <option value="<?php echo $value; ?>" <?php echo set_select('ban_duration', $value); ?>><?php echo $label; ?></option>
            <?php endforeach; ?>
        </select>
        <?php echo form_error('ban_duration', '<p class="text-red-500 mt-1">', '</p>'); ?>
    </div>

    <div>
        <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">Ban User</button>
        <a href="<?php echo site_url('admin/users'); ?>" class="ml-4 text-gray-400 hover:underline">Cancel</a>
    </div>

    <?php echo form_close(); ?>
</body>
</html>
