<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>User Details</title>
    <link rel="stylesheet" href="<?php echo base_url('assets/css/style.css'); ?>">
</head>
<body>
    <h1>User Details</h1>
    <?php if (isset($user)): ?>
        <table>
            <tr><th>ID</th><td><?php echo htmlspecialchars($user->id); ?></td></tr>
            <tr><th>Username</th><td><?php echo htmlspecialchars($user->username); ?></td></tr>
            <tr><th>Email</th><td><?php echo htmlspecialchars($user->email); ?></td></tr>
            <tr><th>First Name</th><td><?php echo htmlspecialchars($user->first_name); ?></td></tr>
            <tr><th>Last Name</th><td><?php echo htmlspecialchars($user->last_name); ?></td></tr>
            <tr><th>Role</th><td><?php echo htmlspecialchars($user->role); ?></td></tr>
            <tr><th>Verified</th><td><?php echo $user->is_verified ? 'Yes' : 'No'; ?></td></tr>
            <tr><th>Banned</th><td><?php echo $user->is_banned ? 'Yes' : 'No'; ?></td></tr>
            <tr><th>Created At</th><td><?php echo htmlspecialchars($user->created_at); ?></td></tr>
        </table>
    <?php else: ?>
        <p>User data not available.</p>
    <?php endif; ?>
    <p><a href="<?php echo site_url('admin/users'); ?>">Back to Users List</a></p>
</body>
</html>
