<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Klimaks - Streaming Bokep No.1</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-900 text-white min-h-screen p-6">
    <h1 class="text-3xl font-bold mb-4">Manage Users</h1>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="bg-green-600 p-2 mb-4 rounded">
            <?php echo $this->session->flashdata('success'); ?>
        </div>
    <?php endif; ?>

    <?php if (empty($users)): ?>
        <p>No users found.</p>
    <?php else: ?>
        <table class="w-full table-auto border-collapse border border-gray-700">
            <thead>
                <tr class="bg-gray-800">
                    <th class="border border-gray-600 px-4 py-2">ID</th>
                    <th class="border border-gray-600 px-4 py-2">Username</th>
                    <th class="border border-gray-600 px-4 py-2">Full Name</th>
                    <th class="border border-gray-600 px-4 py-2">Email</th>
                    <th class="border border-gray-600 px-4 py-2">Gender</th>
                    <th class="border border-gray-600 px-4 py-2">Country</th>
                    <th class="border border-gray-600 px-4 py-2">Date of Birth</th>
                    <th class="border border-gray-600 px-4 py-2">Role</th>
                    <th class="border border-gray-600 px-4 py-2">Status</th>
                    <th class="border border-gray-600 px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td class="border border-gray-600 px-4 py-2"><?php echo $user->id; ?></td>
                        <td class="border border-gray-600 px-4 py-2"><?php echo htmlspecialchars($user->username); ?></td>
                        <td class="border border-gray-600 px-4 py-2">
                            <?php 
                                echo htmlspecialchars($user->full_name ?? 'N/A');
                            ?>
                        </td>
                        <td class="border border-gray-600 px-4 py-2"><?php echo htmlspecialchars($user->email); ?></td>
                        <td class="border border-gray-600 px-4 py-2">
                            <?php 
                                echo ucfirst($user->gender ?? 'N/A');
                            ?>
                        </td>
                        <td class="border border-gray-600 px-4 py-2">
                            <?php 
                                echo htmlspecialchars($user->country ?? 'N/A');
                            ?>
                        </td>
                        <td class="border border-gray-600 px-4 py-2">
                            <?php 
                                echo $user->date_of_birth ? date('d/m/Y', strtotime($user->date_of_birth)) : 'N/A';
                            ?>
                        </td>
                        <td class="border border-gray-600 px-4 py-2"><?php echo ucfirst($user->role); ?></td>
                        <td class="border border-gray-600 px-4 py-2">
                            <?php 
                                if (isset($user->is_banned) && $user->is_banned) {
                                    echo 'Banned';
                                } else {
                                    echo 'Active';
                                }
                            ?>
                        </td>
                        <td class="border border-gray-600 px-4 py-2">
                            <a href="<?php echo site_url('admin/user_view/'.$user->id); ?>" class="text-yellow-400 hover:underline mr-2">View</a>
                            <a href="<?php echo site_url('admin/user_edit/'.$user->id); ?>" class="text-yellow-400 hover:underline mr-2">Edit</a>
                            <a href="<?php echo site_url('admin/user_ban/'.$user->id); ?>" class="text-red-600 hover:underline mr-2" onclick="return confirm('Ban this user?');">Ban</a>
                            <a href="<?php echo site_url('admin/user_delete/'.$user->id); ?>" class="text-red-600 hover:underline" onclick="return confirm('Delete this user?');">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</body>
</html>
