<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Klimaks - Streaming Bokep No.1</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-900 text-white min-h-screen p-6">
    <h1 class="text-3xl font-bold mb-4"><?php echo isset($video) ? 'Edit Video' : 'Create Video'; ?></h1>

    <?php echo validation_errors('<div class="bg-red-600 p-2 mb-4 rounded">', '</div>'); ?>

    <?php echo form_open_multipart(isset($video) ? 'admin/video_edit/'.$video->id : 'admin/video_create'); ?>

    <div class="mb-4">
        <label class="block mb-1" for="title">Title</label>
        <input type="text" name="title" id="title" value="<?php echo set_value('title', isset($video) ? $video->title : ''); ?>" class="w-full p-2 rounded text-gray-900" required />
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="description">Description</label>
        <textarea name="description" id="description" rows="4" class="w-full p-2 rounded text-gray-900" required><?php echo set_value('description', isset($video) ? $video->description : ''); ?></textarea>
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="thumbnail">Thumbnail (optional)</label>
        <input type="file" name="thumbnail" id="thumbnail" />
        <?php if (isset($video) && $video->thumbnail): ?>
            <img src="<?php echo base_url('uploads/thumbnails/' . $video->thumbnail); ?>" alt="Thumbnail" class="mt-2 max-w-xs rounded" />
        <?php endif; ?>
    </div>
    <div class="mb-4">
        <label class="block mb-1" for="video_file">Video File (Max size: 100MB) <?php echo isset($video) ? '(Leave blank to keep current)' : ''; ?></label>
        <input type="file" name="video_file" id="video_file" <?php echo isset($video) ? '' : 'required'; ?> />
        <?php if (isset($error)) : ?>
            <div class="text-red-500 mt-2"><?php echo $error; ?></div>
        <?php endif; ?>
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="status">Status</label>
        <select name="status" id="status" class="w-full p-2 rounded text-gray-900" required>
            <option value="draft" <?php echo set_select('status', 'draft', isset($video) && $video->status == 'draft'); ?>>Draft</option>
            <option value="published" <?php echo set_select('status', 'published', isset($video) && $video->status == 'published'); ?>>Published</option>
        </select>
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="categories">Categories</label>
        <select name="categories[]" id="categories" multiple class="w-full p-2 rounded text-gray-900" required>
            <?php foreach ($categories as $category): ?>
                <option value="<?php echo $category->id; ?>"
                    <?php
                    if (isset($video) && !empty($video->categories)) {
                        foreach ($video->categories as $cat) {
                            if ($cat->id == $category->id) {
                                echo 'selected';
                            }
                        }
                    }
                    ?>
                >
                    <?php echo htmlspecialchars($category->name); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="tags">Tags (comma separated)</label>
        <input type="text" name="tags" id="tags" value="<?php
            if (isset($video) && !empty($video->tags)) {
                echo htmlspecialchars(implode(', ', array_map(function($tag) { return $tag->name; }, $video->tags)));
            } else {
                echo set_value('tags');
            }
        ?>" class="w-full p-2 rounded text-gray-900" />
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="visibility">Visibility</label>
        <select name="visibility" id="visibility" class="w-full p-2 rounded text-gray-900" required>
            <option value="public" <?php echo set_select('visibility', 'public', isset($video) && $video->visibility == 'public'); ?>>Public</option>
            <option value="unlisted" <?php echo set_select('visibility', 'unlisted', isset($video) && $video->visibility == 'unlisted'); ?>>Unlisted</option>
            <option value="private" <?php echo set_select('visibility', 'private', isset($video) && $video->visibility == 'private'); ?>>Private</option>
        </select>
    </div>

    <button type="submit" class="bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-bold py-2 px-4 rounded">
        <?php echo isset($video) ? 'Update Video' : 'Create Video'; ?>
    </button>

    <?php echo form_close(); ?>
</body>
</html>
