<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Klimaks - Streaming Bokep No.1</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-900 text-white min-h-screen p-6">
    <h1 class="text-3xl font-bold mb-4">Create Video with Google Drive</h1>

    <?php echo validation_errors('<div class="bg-red-600 p-2 mb-4 rounded">', '</div>'); ?>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="bg-green-600 p-2 mb-4 rounded">
            <?php echo $this->session->flashdata('success'); ?>
        </div>
    <?php endif; ?>

    <?php echo form_open_multipart('admin/video_create'); ?>

    <div class="mb-4">
        <label class="block mb-1" for="title">Judul Video</label>
        <input type="text" name="title" id="title" value="<?php echo set_value('title'); ?>" class="w-full p-2 rounded text-gray-900" required />
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="description">Deskripsi</label>
        <textarea name="description" id="description" rows="4" class="w-full p-2 rounded text-gray-900" required><?php echo set_value('description'); ?></textarea>
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="drive_link">Link Google Drive</label>
        <input type="url" name="drive_link" id="drive_link" value="<?php echo set_value('drive_link'); ?>" 
               class="w-full p-2 rounded text-gray-900" 
               placeholder="https://drive.google.com/file/d/FILE_ID/view?usp=sharing" required />
        <p class="text-sm text-gray-400 mt-1">Masukkan link share Google Drive yang valid</p>
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="thumbnail">Thumbnail (optional)</label>
        <input type="file" name="thumbnail" id="thumbnail" />
        <p class="text-sm text-gray-400 mt-1">Format: jpg, jpeg, png, gif (max 2MB)</p>
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="status">Status</label>
        <select name="status" id="status" class="w-full p-2 rounded text-gray-900" required>
            <option value="draft" <?php echo set_select('status', 'draft'); ?>>Draft</option>
            <option value="published" <?php echo set_select('status', 'published', TRUE); ?>>Published</option>
        </select>
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="categories">Categories</label>
        <select name="categories[]" id="categories" multiple class="w-full p-2 rounded text-gray-900" required>
            <?php foreach ($categories as $category): ?>
                <option value="<?php echo $category->id; ?>" <?php echo set_select('categories[]', $category->id); ?>>
                    <?php echo htmlspecialchars($category->name); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="tags">Tags (comma separated)</label>
        <input type="text" name="tags" id="tags" value="<?php echo set_value('tags'); ?>" 
               class="w-full p-2 rounded text-gray-900" 
               placeholder="tag1, tag2, tag3" />
    </div>

    <div class="mb-4">
        <label class="block mb-1" for="visibility">Visibility</label>
        <select name="visibility" id="visibility" class="w-full p-2 rounded text-gray-900" required>
            <option value="public" <?php echo set_select('visibility', 'public', TRUE); ?>>Public</option>
            <option value="unlisted" <?php echo set_select('visibility', 'unlisted'); ?>>Unlisted</option>
            <option value="private" <?php echo set_select('visibility', 'private'); ?>>Private</option>
        </select>
    </div>

    <button type="submit" class="bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-bold py-2 px-4 rounded">
        Create Video
    </button>

    <?php echo form_close(); ?>
</body>
</html>
