<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Klimaks - Streaming Bokep No.1</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
</head>

<body class="bg-gray-900 text-white min-h-screen p-6">

    <header class="bg-gray-800 p-4 shadow-md">
        <div class="container mx-auto flex justify-between items-center">
            <h1 class="text-3xl font-bold">Admin Dashboard</h1>
            <nav>
                <a href="<?php echo site_url('admin/videos'); ?>" class="px-3 py-2 hover:text-yellow-400">Videos</a>
                <a href="<?php echo site_url('admin/users'); ?>" class="px-3 py-2 hover:text-yellow-400">Users</a>
                <a href="<?php echo site_url('admin/banners'); ?>" class="px-3 py-2 hover:text-yellow-400">Banners</a>
                <a href="<?php echo site_url('admin/categories'); ?>"
                    class="px-3 py-2 hover:text-yellow-400">Categories</a>
                <a href="<?php echo site_url('admin/tags'); ?>" class="px-3 py-2 hover:text-yellow-400">Tags</a>
                <a href="<?php echo site_url('auth/logout'); ?>" class="px-3 py-2 hover:text-yellow-400">Logout</a>
            </nav>
        </div>
    </header>

    <h1 class="text-3xl font-bold mb-4">Manage Videos</h1>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="bg-green-600 p-2 mb-4 rounded">
            <?php echo $this->session->flashdata('success'); ?>
        </div>
    <?php endif; ?>

    <a href="<?php echo site_url('admin/video_create'); ?>"
        class="bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-bold py-2 px-4 rounded mb-4 inline-block">Add New
        Video</a>

    <?php if (empty($videos)): ?>
        <p>No videos found.</p>
    <?php else: ?>
        <table class="w-full table-auto border-collapse border border-gray-700">
            <thead>
                <tr class="bg-gray-800">
                    <th class="border border-gray-600 px-4 py-2">ID</th>
                    <th class="border border-gray-600 px-4 py-2">Thumbnail</th>
                    <th class="border border-gray-600 px-4 py-2">Title</th>
                    <th class="border border-gray-600 px-4 py-2">Categories</th>
                    <th class="border border-gray-600 px-4 py-2">Status</th>
                    <th class="border border-gray-600 px-4 py-2">Visibility</th>
                    <th class="border border-gray-600 px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($videos as $video): ?>
                    <tr>
                        <td class="border border-gray-600 px-4 py-2"><?php echo $video->id; ?></td>
                        <td class="border border-gray-600 px-4 py-2">
                            <?php if (!empty($video->thumbnail)): ?>
                                <img src="<?php echo base_url('uploads/thumbnails/' . $video->thumbnail); ?>" alt="Thumbnail"
                                    class="w-20 h-20 object-cover rounded" />
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </td>
                        <td class="border border-gray-600 px-4 py-2"><?php echo htmlspecialchars($video->title); ?></td>
                        <td class="border border-gray-600 px-4 py-2">
                            <?php
                            if (!empty($video->categories)) {
                                $category_names = array_map(function ($cat) {
                                    return htmlspecialchars($cat->name);
                                }, $video->categories);
                                echo implode(', ', $category_names);
                            } else {
                                echo 'N/A';
                            }
                            ?>
                        </td>
                        <td class="border border-gray-600 px-4 py-2"><?php echo ucfirst($video->status); ?></td>
                        <td class="border border-gray-600 px-4 py-2"><?php echo ucfirst($video->visibility); ?></td>
                        <td class="border border-gray-600 px-4 py-2">
                            <a href="<?php echo site_url('admin/video_edit/' . $video->id); ?>"
                                class="text-yellow-400 hover:underline mr-2">Edit</a>
                            <a href="<?php echo site_url('admin/video_delete/' . $video->id); ?>"
                                class="text-red-600 hover:underline"
                                onclick="return confirm('Are you sure you want to delete this video?');">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</body>

</html>