<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title; ?></title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Custom CSS -->
    <style>
        body {
            background: url('<?php echo base_url("assets/auth/BG.png"); ?>') no-repeat center center fixed;
            background-size: cover;
            min-height: 100vh;
            display: flex;
            align-items: center;
            padding: 20px 0;
        }

        .register-container {
            background: none;
            /* transparan putih tipis */
            backdrop-filter: blur(5px);
            /* efek blur */
            -webkit-backdrop-filter: blur(2px);
            border-radius: 15px;
            /* border tipis transparan */
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            overflow: hidden;
            max-width: 500px;
            width: 100%;
            margin: 0 auto;
        }


        .register-header {
            background: transparent;
            color: white;
            padding: 30px;
            text-align: center;
        }

        .register-form {
            padding: 40px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            font-weight: 600;
            color: #ffffffff;
            margin-bottom: 8px;
        }

        .form-control {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 12px 15px;
            font-size: 16px;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }

        .invalid-feedback {
            display: block;
            color: #dc3545;
            font-size: 14px;
            margin-top: 5px;
        }

        .btn-register {
            background: transparent;
            border: none;
            border-radius: 8px;
            color: white;
            font-weight: 600;
            padding: 12px 30px;
            width: 100%;
            font-size: 16px;
            transition: all 0.3s ease;
        }

        .btn-register:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 255, 255, 0.4);
            color: #ff0000ff;
        }

        .age-verification {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-top: 10px;
        }

        .age-verification input[type="checkbox"] {
            width: 20px;
            height: 20px;
            accent-color: #ff0000ff;
        }

        .age-verification label {
            margin-bottom: 0;
            font-size: 14px;
            color: #ffffffff;
        }

        .login-link {
            text-align: center;
            margin-top: 20px;
            color: #ffffffff;
        }

        .login-link a {
            color: #ff0000ff;
            text-decoration: none;
            font-weight: 600;
        }

        .login-link a:hover {
            text-decoration: underline;
        }

        .password-toggle {
            position: relative;
        }

        .password-toggle .toggle-password {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #666;
        }

        .logo {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .logo span {
            color: #ff0000ff;
        }
    </style>
</head>

<body>
    <div class="register-container">
        <div class="register-header">
            <div class="logo">KLIMAKS<span>.COM</span></div>
            <h2>Create Your Account</h2>
            <p>Join the largest adult community</p>
        </div>

        <div class="register-form">
            <?php if ($this->session->flashdata('error')): ?>
                <div class="alert alert-danger">
                    <?php echo $this->session->flashdata('error'); ?>
                </div>
            <?php endif; ?>

            <?php if ($this->session->flashdata('success')): ?>
                <div class="alert alert-success">
                    <?php echo $this->session->flashdata('success'); ?>
                </div>
            <?php endif; ?>

            <form action="<?php echo site_url('auth/process_register'); ?>" method="post" id="registerForm">
                <div class="form-group">
                    <label for="username" class="form-label">
                        <i class="fas fa-user"></i> Username *
                    </label>
                    <input type="text" class="form-control <?php echo form_error('username') ? 'is-invalid' : ''; ?>"
                        id="username" name="username" value="<?php echo set_value('username'); ?>"
                        placeholder="Enter your username" required>
                    <?php echo form_error('username', '<div class="invalid-feedback">', '</div>'); ?>
                </div>

                <div class="form-group">
                    <label for="email" class="form-label">
                        <i class="fas fa-envelope"></i> Email Address *
                    </label>
                    <input type="email" class="form-control <?php echo form_error('email') ? 'is-invalid' : ''; ?>"
                        id="email" name="email" value="<?php echo set_value('email'); ?>" placeholder="Enter your email"
                        required>
                    <?php echo form_error('email', '<div class="invalid-feedback">', '</div>'); ?>
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">
                        <i class="fas fa-lock"></i> Password *
                    </label>
                    <div class="password-toggle">
                        <input type="password"
                            class="form-control <?php echo form_error('password') ? 'is-invalid' : ''; ?>" id="password"
                            name="password" placeholder="Enter your password" required>
                        <i class="fas fa-eye toggle-password" onclick="togglePassword('password')"></i>
                    </div>
                    <?php echo form_error('password', '<div class="invalid-feedback">', '</div>'); ?>
                </div>

                <div class="form-group">
                    <label for="confirm_password" class="form-label">
                        <i class="fas fa-lock"></i> Confirm Password *
                    </label>
                    <div class="password-toggle">
                        <input type="password"
                            class="form-control <?php echo form_error('confirm_password') ? 'is-invalid' : ''; ?>"
                            id="confirm_password" name="confirm_password" placeholder="Confirm your password" required>
                        <i class="fas fa-eye toggle-password" onclick="togglePassword('confirm_password')"></i>
                    </div>
                    <?php echo form_error('confirm_password', '<div class="invalid-feedback">', '</div>'); ?>
                </div>

                <div class="form-group">
                    <label for="birth_date" class="form-label">
                        <i class="fas fa-calendar-alt"></i> Date of Birth *
                    </label>
                    <input type="date" class="form-control <?php echo form_error('birth_date') ? 'is-invalid' : ''; ?>"
                        id="birth_date" name="birth_date" value="<?php echo set_value('birth_date'); ?>"
                        max="<?php echo date('Y-m-d', strtotime('-18 years')); ?>" required>
                    <?php echo form_error('birth_date', '<div class="invalid-feedback">', '</div>'); ?>
                    <small class="text-muted">You must be 18 years or older to register</small>
                </div>

                <div class="form-group">
                    <div class="age-verification">
                        <input type="checkbox" id="age_verification" name="age_verification" required>
                        <label for="age_verification">
                            I confirm that I am 18 years of age or older and agree to the
                            <a href="#" data-bs-toggle="modal" data-bs-target="#termsModal">Terms of Service</a>
                        </label>
                    </div>
                    <?php echo form_error('age_verification', '<div class="invalid-feedback">', '</div>'); ?>
                </div>

                <button type="submit" class="btn btn-register">
                    <i class="fas fa-user-plus"></i> Create Account
                </button>
            </form>

            <div class="login-link">
                Already have an account? <a href="<?php echo site_url('auth/login'); ?>">Sign in here</a>
            </div>
        </div>
    </div>

    <!-- Terms Modal -->
    <div class="modal fade" id="termsModal" tabindex="-1" aria-labelledby="termsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="termsModalLabel">Terms of Service</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h6>By registering, you agree to:</h6>
                    <ul>
                        <li>Be 18 years of age or older</li>
                        <li>Not share explicit content with minors</li>
                        <li>Respect other users and their privacy</li>
                        <li>Follow all community guidelines</li>
                        <li>Not upload illegal content</li>
                    </ul>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Custom JavaScript -->
    <script>
        // Toggle password visibility
        function togglePassword(inputId) {
            const input = document.getElementById(inputId);
            const icon = input.nextElementSibling;

            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }

        // Real-time password confirmation
        document.getElementById('confirm_password').addEventListener('input', function () {
            const password = document.getElementById('password').value.trim();
            const confirmPassword = this.value.trim();
            const parent = this.parentElement.parentElement;
            const errorDiv = parent.querySelector('.invalid-feedback');

            if (password !== confirmPassword) {
                if (!errorDiv) {
                    const newError = document.createElement('div');
                    newError.className = 'invalid-feedback';
                    newError.textContent = 'Passwords do not match';
                    parent.appendChild(newError);
                }
                this.classList.add('is-invalid');
            } else {
                // Remove client-side error div
                if (errorDiv) {
                    errorDiv.remove();
                }
                // Remove server-side error div rendered by PHP
                const serverErrorDiv = this.parentElement.parentElement.querySelector('div.invalid-feedback');
                if (serverErrorDiv) {
                    serverErrorDiv.remove();
                }
                this.classList.remove('is-invalid');
            }
        });

        // Age verification check
        document.getElementById('birth_date').addEventListener('change', function () {
            const birthDate = new Date(this.value);
            const today = new Date();
            const age = today.getFullYear() - birthDate.getFullYear();
            const monthDiff = today.getMonth() - birthDate.getMonth();

            const actualAge = (monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate())) ? age - 1 : age;

            if (actualAge < 18) {
                this.classList.add('is-invalid');
                if (!this.nextElementSibling || !this.nextElementSibling.classList.contains('invalid-feedback')) {
                    const error = document.createElement('div');
                    error.className = 'invalid-feedback';
                    error.textContent = 'You must be 18 years or older';
                    this.parentElement.appendChild(error);
                }
            } else {
                this.classList.remove('is-invalid');
                const error = this.nextElementSibling;
                if (error && error.classList.contains('invalid-feedback')) {
                    error.remove();
                }
            }
        });

        // Form submission validation
        document.getElementById('registerForm').addEventListener('submit', function (e) {
            const ageVerification = document.getElementById('age_verification');
            const password = document.getElementById('password').value.trim();
            const confirmPassword = document.getElementById('confirm_password').value.trim();

            if (!ageVerification.checked) {
                e.preventDefault();
                alert('Please confirm that you are 18 years or older');
                return false;
            }

            if (password !== confirmPassword) {
                e.preventDefault();
                const confirmInput = document.getElementById('confirm_password');
                const parent = confirmInput.parentElement.parentElement;
                let errorDiv = parent.querySelector('.invalid-feedback');
                if (!errorDiv) {
                    errorDiv = document.createElement('div');
                    errorDiv.className = 'invalid-feedback';
                    errorDiv.textContent = 'Passwords do not match';
                    parent.appendChild(errorDiv);
                }
                confirmInput.classList.add('is-invalid');
                confirmInput.focus();
                return false;
            }
        });
    </script>
</body>

</html>