<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Klimaks - Adult | Step Mom | Step Sister: Streaming Bokep No.1</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        .video-card {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            cursor: pointer;
        }

        .video-card img {
            width: 100%;
            height: 240px;
            object-fit: cover;
            display: block;
            padding-left: 0.5rem;
            padding-right: 0.5rem;
        }

        .video-duration {
            position: absolute;
            bottom: 0.5rem;
            right: 0.5rem;
            background: rgba(0, 0, 0, 0.7);
            color: white;
            padding: 0.1rem 0.4rem;
            font-size: 0.75rem;
            border-radius: 0.25rem;
        }

        .video-hd {
            position: absolute;
            top: 0.5rem;
            left: 0.5rem;
            background: rgba(255, 255, 255, 0.8);
            color: black;
            font-weight: bold;
            padding: 0.1rem 0.4rem;
            font-size: 0.75rem;
            border-radius: 0.25rem;
        }

        .video-title {
            color: #FFA500;
            font-size: 0.875rem;
            margin-top: 0.25rem;
            line-height: 1.2;
            height: 3rem;
            overflow: hidden;
        }

        .videos-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
            gap: 1rem;
        }

        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
            color: white;
            font-weight: bold;
            font-size: 1.25rem;
        }

        .more-videos {
            color: #FFA500;
            font-size: 0.875rem;
            cursor: pointer;
        }
    </style>
</head>

<body class="bg-black text-white min-h-screen flex flex-col">
    <header class="bg-gray-900 p-4 shadow-md">
        <div class="container mx-auto flex justify-between items-center">
            <h1 class="text-3xl font-bold">Klimaks</h1>
            <nav>
                <a href="#" class="px-3 py-2 hover:text-yellow-400">Home</a>
                <?php if (!$this->session->userdata('user_id')): ?>
                    <button onclick="openLoginModal()" class="px-3 py-2 hover:text-yellow-400 cursor-pointer">Login</button>
                    <a href="<?php echo site_url('auth/register'); ?>" class="px-3 py-2 hover:text-yellow-400">Register</a>
                <?php else: ?>
                    <a href="<?php echo site_url('user'); ?>" class="px-3 py-2 hover:text-yellow-400">Dashboard</a>
                    <a href="<?php echo site_url('auth/logout'); ?>" class="px-3 py-2 hover:text-yellow-400">Logout</a>
                <?php endif; ?>
            </nav>
        </div>
    </header>
    <main class="flex-grow container mx-auto p-6">
        <div class="section-header">
            <div>Bokep Indonesia Terbaru</div>
            <div class="more-videos">+ More videos</div>
        </div>
        <div class="videos-grid grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
            <?php if (!empty($videos)): ?>
                <?php foreach ($videos as $video): ?>
                    <a href="<?php echo site_url('home/watch/' . $video->id); ?>"
                        class="video-card relative group block rounded-md overflow-hidden cursor-pointer">
                        <img src="<?php echo base_url('uploads/thumbnails/' . ($video->thumbnail ?? 'default.jpg')); ?>"
                            alt="<?php echo htmlspecialchars($video->title); ?>" class="w-full h-60 object-cover rounded-md" />
                        <div
                            class="absolute inset-0 bg-black bg-opacity-50 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                            <svg class="w-16 h-16 text-orange-500" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M8 5v14l11-7z" />
                            </svg>
                        </div>
                        <div class="video-hd absolute top-2 left-2 bg-white text-black font-bold px-2 py-0.5 text-xs rounded">HD
                        </div>
                        <div
                            class="video-duration absolute bottom-2 right-2 bg-black bg-opacity-70 text-white text-xs px-2 py-0.5 rounded">
                            <?php
                            $duration = isset($video->duration) ? gmdate("H:i:s", $video->duration) : "00:00";
                            echo ltrim($duration, "0:");
                            ?>
                        </div>
                        <div class="video-title mt-2 text-orange-500 font-semibold text-sm h-12 overflow-hidden">
                            <?php echo htmlspecialchars($video->title); ?>
                        </div>
                    </a>
                <?php endforeach; ?>
            <?php else: ?>
                <p>No videos found.</p>
            <?php endif; ?>
        </div>
    </main>

    <!-- Modal -->
    <div id="video-modal"
        class="fixed inset-0 bg-black bg-opacity-90 flex items-center justify-center opacity-0 pointer-events-none transition-opacity duration-500 z-50">
        <div class="relative w-full h-full max-w-5xl max-h-full mx-4 my-8 bg-black rounded-md shadow-lg flex flex-col">
            <button id="modal-close"
                class="absolute top-4 right-4 text-white text-4xl font-bold hover:text-orange-500 focus:outline-none z-50">&times;</button>
            <video id="modal-video" class="w-full h-full rounded-md bg-black" controls preload="metadata"></video>
        </div>
    </div>

    <script>
        (function () {
            const modal = document.getElementById('video-modal');
            const video = document.getElementById('modal-video');
            const closeBtn = document.getElementById('modal-close');
            const videoCards = document.querySelectorAll('.video-card');

            function openModal(src) {
                video.src = src;
                video.play();
                modal.classList.remove('opacity-0', 'pointer-events-none');
                modal.classList.add('opacity-100');
                document.body.style.overflow = 'hidden';
            }

            function closeModal() {
                video.pause();
                video.currentTime = 0;
                video.src = '';
                modal.classList.remove('opacity-100');
                modal.classList.add('opacity-0');
                setTimeout(() => {
                    modal.classList.add('pointer-events-none');
                }, 500);
                document.body.style.overflow = '';
            }

            videoCards.forEach(card => {
                card.addEventListener('click', () => {
                    const src = card.getAttribute('data-video-src');
                    if (src) {
                        openModal(src);
                    }
                });
            });

            closeBtn.addEventListener('click', closeModal);
            modal.addEventListener('click', (e) => {
                if (e.target === modal) {
                    closeModal();
                }
            });

            // Accessibility: close modal on ESC key
            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape' && !modal.classList.contains('opacity-0')) {
                    closeModal();
                }
            });
        })();
    </script>

    <!-- Login Modal -->
    <div id="loginModal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center z-50 hidden">
        <div class="bg-gray-900 rounded-lg p-8 max-w-md w-full mx-4">
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-2xl font-bold text-white">Login</h2>
                <button onclick="closeModal('loginModal')"
                    class="text-gray-400 hover:text-white text-2xl">&times;</button>
            </div>

            <form id="loginForm" class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Username or Email</label>
                    <input type="text" name="username" required
                        class="w-full px-3 py-2 bg-gray-800 border border-gray-700 rounded-md text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-orange-500">
                    <div class="error-message text-red-400 text-sm mt-1 hidden" data-error="username"></div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Password</label>
                    <input type="password" name="password" required
                        class="w-full px-3 py-2 bg-gray-800 border border-gray-700 rounded-md text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-orange-500">
                    <div class="error-message text-red-400 text-sm mt-1 hidden" data-error="password"></div>
                </div>

                <div class="login-error text-red-400 text-sm hidden"></div>

                <button type="submit"
                    class="w-full bg-orange-500 hover:bg-orange-600 text-white font-bold py-2 px-4 rounded-md transition duration-300">
                    Sign In
                </button>

                <div class="text-center">
                    <a href="<?php echo site_url('auth/register'); ?>"
                        class="text-orange-400 hover:text-orange-300 text-sm">
                        Don't have an account? Register here
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Register Modal - REMOVED -->

    <footer class="bg-gray-900 p-4 text-center text-gray-400">
        &copy; 2025 Klimaks.com. All rights reserved.
    </footer>

    <script>
        var BASE_URL = '<?php echo site_url(); ?>';
    </script>
    <script src="<?php echo base_url('assets/js/auth-modal.js'); ?>"></script>
</body>

</html>