<!-- Login Modal -->
<div id="loginModal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center z-50 hidden">
    <div class="bg-gray-900 rounded-lg p-8 max-w-md wInformation Gathered:
- The Auth controller handles login and registration with separate views: `auth/login.php` and `auth/register.php`.
- The home page (`application/views/home.php`) currently has login and register links that redirect to separate pages.
- The main JavaScript file (`assets/js/main.js`) has general form validation and UI utilities but no modal handling for login/register.
- The login and register forms have server-side validation and session flash messages for errors and success.
- The site uses Tailwind CSS for styling.

Plan:
- Modify `application/views/home.php`:
  - Replace the login and register links in the header with buttons that open modal popups.
  - Add modal HTML for login and register forms inside the home page.
- Extract the login and register form HTML from `auth/login.php` and `auth/register.php` and embed them inside the modals in `home.php`.
- Modify the forms to submit via AJAX to the existing `process_login` and `process_register` endpoints to avoid page reload.
- Add JavaScript in `assets/js/main.js` to handle:
  - Opening and closing the login and register modals.
  - Submitting the forms via AJAX.
  - Displaying validation errors and success messages inside the modals.
- Ensure form validation still works client-side and server-side.
- Remove or disable the separate login and register pages or redirect them to home with modals if accessed directly (optional).

Dependent Files to Edit:
- `application/views/home.php` (add modals and buttons)
- `application/views/auth/login.php` (read for form HTML)
- `application/views/auth/register.php` (read for form HTML)
- `assets/js/main.js` (add modal and AJAX handling)

Followup Steps:
- After editing, test login and registration modals for correct display, validation, and submission without page reload.
- Verify error and success messages appear correctly.
- Confirm that user session is set and user is redirected or page updated accordingly after login/register.

Please confirm if I can proceed with this plan or if you have any additional requirements or preferences. 

<ask_followup_question>
<question>May I proceed with implementing the login and register modals on the home page with AJAX form submission as described?</question>
</ask_followup_question>
