<div class="banner-container">
    <?php if (!empty($banners)): ?>
        <?php foreach ($banners as $banner): ?>
            <a href="<?= site_url('banner/track_click/' . $banner->id) ?>" 
               target="_blank" 
               rel="noopener noreferrer" 
               class="block mb-4 banner-click-track"
               data-banner-id="<?= $banner->id ?>">
                <img src="<?= base_url('uploads/banners/' . $banner->image_path) ?>" 
                     alt="<?= htmlspecialchars($banner->title) ?>"
                     class="w-full h-auto max-w-full mx-auto rounded-lg shadow-lg"
                     style="max-height: 150px; object-fit: contain;">
            </a>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="text-center text-gray-400 py-8">
            <p>No banners available</p>
        </div>
    <?php endif; ?>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Track banner clicks
    const bannerLinks = document.querySelectorAll('.banner-click-track');
    bannerLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            const bannerId = this.getAttribute('data-banner-id');
            if (bannerId) {
                // Send AJAX request to track click
                fetch('<?= site_url('banner/track_click') ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: 'banner_id=' + bannerId + '&<?= $this->security->get_csrf_token_name() ?>=<?= $this->security->get_csrf_hash() ?>'
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        console.log('Banner click tracked successfully');
                    }
                })
                .catch(error => console.error('Error tracking banner click:', error));
            }
        });
    });
});
</script>
