<?php
/**
 * Template untuk menampilkan banner kiri-kanan khusus desktop
 * Layout horizontal dengan banner kiri dan kanan sejajar secara horizontal
 * Responsive untuk desktop 1024px ke atas
 */
?>
<?php if (!empty($banners) && count($banners) >= 2): ?>
<div class="desktop-banner-container hidden md:flex justify-center items-center space-x-4">
    <!-- Banner Kiri -->
    <div class="banner-left banner-item">
        <?php 
        $left_banner = $banners[0];
        $left_link = $left_banner->link_url ?? '';
        $left_image = base_url('uploads/banners/' . $left_banner->image_path);
        ?>
        <?php if ($left_link): ?>
            <a href="<?php echo $left_link; ?>" target="_blank" rel="noopener noreferrer">
                <img src="<?php echo $left_image; ?>" 
                     alt="<?php echo htmlspecialchars($left_banner->title); ?>"
                     class="banner-desktop-img">
            </a>
        <?php else: ?>
            <img src="<?php echo $left_image; ?>" 
                 alt="<?php echo htmlspecialchars($left_banner->title); ?>"
                 class="banner-desktop-img">
        <?php endif; ?>
    </div>

    <!-- Banner Kanan -->
    <div class="banner-right banner-item">
        <?php 
        $right_banner = $banners[1];
        $right_link = $right_banner->link_url ?? '';
        $right_image = base_url('uploads/banners/' . $right_banner->image_path);
        ?>
        <?php if ($right_link): ?>
            <a href="<?php echo $right_link; ?>" target="_blank" rel="noopener noreferrer">
                <img src="<?php echo $right_image; ?>" 
                     alt="<?php echo htmlspecialchars($right_banner->title); ?>"
                     class="banner-desktop-img">
            </a>
        <?php else: ?>
            <img src="<?php echo $right_image; ?>" 
                 alt="<?php echo htmlspecialchars($right_banner->title); ?>"
                 class="banner-desktop-img">
        <?php endif; ?>
    </div>
</div>

<!-- Mobile Fallback (hidden on desktop) -->
<div class="mobile-banner-container md:hidden">
    <?php $this->load->view('templates/banner_display', ['banners' => $banners]); ?>
</div>

<style>
/* Desktop Banner Container - Khusus layar 1024px ke atas */
.desktop-banner-container {
    width: 100%;
    max-width: 1500px;
    margin: 0 auto;
    padding: 10px 0;
}

/* Banner kiri dan kanan sejajar horizontal */
.banner-left,
.banner-right {
    width: 728px;
    height: 90px;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.3);
    transition: transform 0.3s ease;
}

.banner-left:hover,
.banner-right:hover {
    transform: translateY(-2px);
}

.banner-desktop-img {
    width: 100%;
    height: 90px;
    object-fit: contain;
    display: block;
}

/* Responsive untuk layar besar */
@media (min-width: 1440px) {
    .desktop-banner-container {
        max-width: 1800px;
    }
}

@media (min-width: 1920px) {
    .desktop-banner-container {
        max-width: 2100px;
    }
}
</style>

<?php else: ?>
<!-- Fallback untuk banner tunggal atau kosong -->
<div class="desktop-banner-container hidden md:block">
    <div class="text-center py-8">
        <p class="text-gray-400">Desktop banner layout requires at least 2 banners</p>
    </div>
</div>
<div class="mobile-banner-container md:hidden">
    <?php $this->load->view('templates/banner_display', ['banners' => $banners]); ?>
</div>
<?php endif; ?>
