<!-- Mobile Sidebar Template -->
<aside id="sidebar"
    class="fixed inset-y-0 left-0 transform -translate-x-full md:relative md:translate-x-0 transition-transform duration-300 bg-gray-900 w-full max-w-xs z-50 overflow-y-auto">
    <nav class="mt-10 px-6">
        <!-- User Profile Section -->
        <div class="flex items-center space-x-4 mb-6 p-4 bg-gray-800 rounded-lg">
            <?php 
            $profile_image = $this->session->userdata('profile_image');
            $default_image = base_url('assets/uploads/profile_images/default.png');
            $user_image = $profile_image ? base_url($profile_image) : $default_image;
            ?>
            <img src="<?php echo $user_image; ?>"
                alt="Profile Picture" 
                class="w-20 h-20 rounded-full object-cover border-2 border-yellow-400 shadow-lg">
            <div>
                <p class="text-white font-semibold text-lg">
                    <?php echo htmlspecialchars($this->session->userdata('username') ?? 'Guest'); ?>
                </p>
                <p class="text-gray-400 text-sm">Welcome back!</p>
            </div>
        </div>

        <!-- Navigation Menu -->
        <div class="space-y-2">
            <a href="<?php echo site_url('user'); ?>"
                class="block py-3 px-4 rounded-lg bg-gray-800 hover:bg-yellow-500 hover:text-black transition-colors">
                <i class="fas fa-home mr-2"></i>Home
            </a>
            
            <a href="<?php echo site_url('user/profile'); ?>"
                class="block py-3 px-4 rounded-lg bg-gray-800 hover:bg-yellow-500 hover:text-black transition-colors">
                <i class="fas fa-user mr-2"></i>Profile
            </a>
            
            <a href="<?php echo site_url('user/watch'); ?>"
                class="block py-3 px-4 rounded-lg bg-gray-800 hover:bg-yellow-500 hover:text-black transition-colors">
                <i class="fas fa-play mr-2"></i>Watch
            </a>
            
            <a href="<?php echo site_url('auth/logout'); ?>"
                class="block py-3 px-4 rounded-lg bg-gray-800 hover:bg-red-500 hover:text-black transition-colors">
                <i class="fas fa-sign-out-alt mr-2"></i>Logout
            </a>
        </div>

        <!-- Categories Section -->
        <div class="mt-6">
            <h4 class="text-yellow-400 font-semibold mb-3">Categories</h4>
            <div class="space-y-1">
                <?php if (!empty($categories)): ?>
                    <?php foreach ($categories as $category): ?>
                        <a href="<?php echo site_url('category/' . $category->slug); ?>"
                            class="block py-2 px-4 rounded-lg bg-gray-800 hover:bg-yellow-500 hover:text-black transition-colors text-sm">
                            <?php echo htmlspecialchars($category->name); ?>
                        </a>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </nav>
</aside>

<!-- Overlay for mobile -->
<div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden"></div>

<script>
// Mobile sidebar functionality
document.addEventListener('DOMContentLoaded', function() {
    const sidebarToggle = document.getElementById('sidebar-toggle');
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebar-overlay');

    function toggleSidebar() {
        sidebar.classList.toggle('-translate-x-full');
        overlay.classList.toggle('hidden');
        document.body.style.overflow = sidebar.classList.contains('-translate-x-full') ? '' : 'hidden';
    }

    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', toggleSidebar);
    }

    if (overlay) {
        overlay.addEventListener('click', toggleSidebar);
    }

    // Close sidebar when clicking outside on mobile
    document.addEventListener('click', function(e) {
        if (window.innerWidth < 768 && 
            !sidebar.contains(e.target) && 
            !sidebarToggle?.contains(e.target) &&
            !sidebar.classList.contains('-translate-x-full')) {
            toggleSidebar();
        }
    });
});
</script>
