<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Lustoria - User Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
</head>

<body class="bg-black text-white min-h-screen flex flex-col">

    <!-- Header -->
    <header class="bg-gray-900 p-4 shadow-md sticky top-0 z-50">
        <div class="container mx-auto flex justify-between items-center">
            <h1 class="text-3xl font-bold">Lustoria</h1>
            <button id="sidebar-toggle"
                class="block md:hidden p-2 rounded text-yellow-400 border border-yellow-400 focus:outline-none">
                <!-- Hamburger -->
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                </svg>
            </button>

            <!-- Desktop Nav -->
            <nav class="hidden md:flex md:items-center md:space-x-6">
                <a href="<?= site_url('user'); ?>" class="hover:text-yellow-400">Home</a>
                <!-- Dropdown -->
                <div class="relative group">
                    <button class="flex items-center hover:text-yellow-400">
                        Kategori
                        <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>
                    <div
                        class="absolute hidden group-hover:block bg-gray-800 mt-2 rounded shadow-lg z-50 min-w-[200px]">
                        <?php if (!empty($categories)): ?>
                            <?php foreach ($categories as $category): ?>
                                <a href="<?= site_url('category/' . $category->slug); ?>"
                                    class="block px-4 py-2 hover:bg-yellow-500 hover:text-black">
                                    <?= htmlspecialchars($category->name); ?>
                                </a>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <span class="block px-4 py-2 text-gray-400">Tidak ada kategori</span>
                        <?php endif; ?>
                    </div>
                </div>
                <a href="<?= site_url('user/profile'); ?>" class="hover:text-yellow-400">Profile</a>
                <a href="<?= site_url('auth/logout'); ?>" class="hover:text-yellow-400">Logout</a>
            </nav>
        </div>
    </header>

    <!-- Sidebar Mobile -->
    <aside id="sidebar"
        class="fixed inset-y-0 left-0 bg-gray-900 w-64 transform -translate-x-full transition-transform duration-300 z-50 overflow-y-auto">
        <div class="p-4 flex flex-col items-center space-y-2 border-b border-gray-700 text-center">
            <img src="<?= htmlspecialchars($this->session->userdata('profile_image') ?? 'https://via.placeholder.com/80'); ?>"
                alt="Profile Picture" class="w-16 h-16 rounded-full object-cover border-2 border-yellow-400">
            <div>
                <p class="font-semibold"><?= htmlspecialchars($this->session->userdata('username')); ?></p>
                <p class="text-gray-400 text-sm">Welcome back!</p>
            </div>
        </div>
        <nav class="p-4 space-y-2">
            <a href="<?= site_url('user'); ?>"
                class="block py-2 px-3 rounded hover:bg-yellow-500 hover:text-black">Home</a>
            <button id="category-toggle"
                class="w-full text-left py-2 px-3 rounded hover:bg-yellow-500 hover:text-black">
                Kategori ▼
            </button>
            <div id="category-submenu" class="hidden ml-4">
                <?php if (!empty($categories)): ?>
                    <?php foreach ($categories as $category): ?>
                        <a href="<?= site_url('category/' . $category->slug); ?>"
                            class="block py-2 px-3 rounded hover:bg-yellow-500 hover:text-black">
                            <?= htmlspecialchars($category->name); ?>
                        </a>
                    <?php endforeach; ?>
                <?php else: ?>
                    <span class="block py-2 px-3 text-gray-400">Tidak ada kategori</span>
                <?php endif; ?>
            </div>
            <a href="<?= site_url('user/profile'); ?>"
                class="block py-2 px-3 rounded hover:bg-yellow-500 hover:text-black">Profile</a>
            <a href="<?= site_url('auth/logout'); ?>"
                class="block py-2 px-3 rounded hover:bg-yellow-500 hover:text-black">Logout</a>
        </nav>
    </aside>

    <!-- Overlay -->
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden"></div>

    <!-- Main Content -->
    <main class="flex-grow container mx-auto p-4">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-lg font-bold">Bokep Indonesia Terbaru</h2>
            <span class="text-yellow-400 cursor-pointer">+ More videos</span>
        </div>

        <!-- Mobile Video Grid -->
        <div class="sm:hidden">
            <?php if (!empty($grouped_videos)): ?>
                <?php foreach ($grouped_videos as $group): ?>
                    <div class="mb-6">
                        <h3 class="text-yellow-400 font-semibold mb-2"><?= htmlspecialchars($group['category']->name); ?></h3>
                        <div class="overflow-x-auto -mx-4 px-4">
                            <div class="inline-grid grid-rows-2 grid-flow-col gap-4" style="min-width: 320px;">
                                <?php foreach ($group['videos'] as $video): ?>
                                    <a href="<?= site_url('home/watch/' . $video->id); ?>"
                                        class="relative bg-gray-800 rounded-lg overflow-hidden group w-40 h-40">
                                        <img src="<?= base_url('uploads/thumbnails/' . ($video->thumbnail ?? 'default.jpg')); ?>"
                                            class="w-full h-full object-cover" alt="<?= htmlspecialchars($video->title); ?>">
                                        <div
                                            class="absolute inset-0 bg-black bg-opacity-50 flex items-center justify-center opacity-0 group-hover:opacity-100 transition">
                                            <svg class="w-10 h-10 text-orange-500" fill="currentColor" viewBox="0 0 24 24">
                                                <path d="M8 5v14l11-7z" />
                                            </svg>
                                        </div>
                                        <span
                                            class="absolute top-2 left-2 bg-yellow-400 text-black text-xs px-2 py-0.5 rounded">HD</span>
                                        <span class="absolute bottom-2 right-2 bg-black bg-opacity-70 text-xs px-2 py-0.5 rounded">
                                            <?= isset($video->duration) ? gmdate("i:s", $video->duration) : "00:00"; ?>
                                        </span>
                                        <div class="p-1 text-xs text-orange-400 font-semibold line-clamp-2">
                                            <?= htmlspecialchars($video->title); ?>
                                        </div>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-center text-gray-400">No videos found</p>
            <?php endif; ?>
        </div>

        <!-- Desktop Video Grid -->
        <div class="hidden sm:block">
            <?php if (!empty($grouped_videos)): ?>
                <?php foreach ($grouped_videos as $group): ?>
                    <div class="mb-6">
                        <h3 class="text-yellow-400 font-semibold mb-2"><?= htmlspecialchars($group['category']->name); ?></h3>
                        <div class="grid grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-4">
                            <?php foreach ($group['videos'] as $video): ?>
                                <a href="<?= site_url('home/watch/' . $video->id); ?>"
                                    class="relative bg-gray-800 rounded-lg overflow-hidden group">
                                    <img src="<?= base_url('uploads/thumbnails/' . ($video->thumbnail ?? 'default.jpg')); ?>"
                                        class="w-full h-40 object-cover" alt="<?= htmlspecialchars($video->title); ?>">
                                    <div
                                        class="absolute inset-0 bg-black bg-opacity-50 flex items-center justify-center opacity-0 group-hover:opacity-100 transition">
                                        <svg class="w-14 h-14 text-orange-500" fill="currentColor" viewBox="0 0 24 24">
                                            <path d="M8 5v14l11-7z" />
                                        </svg>
                                    </div>
                                    <span
                                        class="absolute top-2 left-2 bg-yellow-400 text-black text-xs px-2 py-0.5 rounded">HD</span>
                                    <span class="absolute bottom-2 right-2 bg-black bg-opacity-70 text-xs px-2 py-0.5 rounded">
                                        <?= isset($video->duration) ? gmdate("i:s", $video->duration) : "00:00"; ?>
                                    </span>
                                    <div class="p-2 text-sm text-orange-400 font-semibold line-clamp-2">
                                        <?= htmlspecialchars($video->title); ?>
                                    </div>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-center text-gray-400">No videos found</p>
            <?php endif; ?>
        </div>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-900 p-4 text-center text-gray-400">
        &copy; 2025 Klimaks.com. All rights reserved.
    </footer>

    <!-- Javascript -->
    <script src="<?= base_url('assets/js/user/user_dashboard.js'); ?>"></script>
    <script src="<?= base_url('assets/js/sidebar/user_dashboard.js'); ?>"></script>
</body>

</html>