<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>User Profile - Klimaks</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body class="bg-gray-100 text-gray-900 min-h-screen flex flex-col">
    <div class="flex flex-col min-h-screen">
        <header class="bg-gray-800 p-4 shadow-md text-white">
            <div class="container mx-auto flex justify-between items-center">
                <h1 class="text-3xl font-bold">Lustoria</h1>
                <button id="sidebar-toggle"
                    class="block md:hidden px-3 py-2 border rounded text-yellow-400 border-yellow-400 focus:outline-none">
                    <!-- Hamburger -->
                    <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>
                <nav class="hidden md:flex md:items-center md:space-x-6">
                    <a href="<?= site_url('user'); ?>" class="px-3 py-2 hover:text-yellow-400">Home</a>

                    <!-- Desktop Category Dropdown -->
                    <div class="relative dropdown">
                        <button class="px-3 py-2 hover:text-yellow-400 cursor-pointer flex items-center">
                            Kategori <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                        <div
                            class="dropdown-menu absolute hidden bg-gray-800 min-w-[200px] shadow-lg rounded-md mt-2 z-50">
                            <?php if (!empty($categories)): ?>
                                <?php foreach ($categories as $category): ?>
                                    <a href="<?= site_url('category/' . $category->slug); ?>"
                                        class="block px-4 py-2 text-sm hover:bg-yellow-500 hover:text-black">
                                        <?= htmlspecialchars($category->name); ?>
                                    </a>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <span class="block px-4 py-2 text-sm text-gray-400">Tidak ada kategori</span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <a href="<?= site_url('user/profile'); ?>" class="px-3 py-2 hover:text-yellow-400">Profile</a>
                    <a href="<?= site_url('auth/logout'); ?>" class="px-3 py-2 hover:text-yellow-400">Logout</a>
                </nav>
            </div>
        </header>

        <div class="flex flex-grow bg-gray-100">

            <!-- Sidebar Mobile -->
            <aside id="sidebar"
                class="fixed inset-y-0 left-0 bg-gray-900 w-64 transform -translate-x-full transition-transform duration-300 z-50 overflow-y-auto">
                <div class="p-4 flex flex-col items-center space-y-2 border-b border-gray-700 text-center">
                    <?php
                    $profile_image = $this->session->userdata('profile_image');
                    $profile_image_url = $profile_image ? base_url($profile_image) : 'https://via.placeholder.com/80';
                    ?>
                    <img src="<?= htmlspecialchars($profile_image_url); ?>" alt="Profile Picture"
                        class="w-16 h-16 rounded-full object-cover border-2 border-yellow-400">
            <div>
                <p class="font-semibold text-white"><?= htmlspecialchars($this->session->userdata('username')); ?></p>
                <p class="text-gray-300 text-sm">Welcome back!</p>
            </div>
                </div>
                <nav class="p-4 space-y-2">
                    <a href="<?= site_url('user'); ?>"
                        class="block py-2 px-3 rounded hover:bg-yellow-500 hover:text-white">Home</a>
                    <button id="category-toggle"
                        class="w-full text-left py-2 px-3 rounded hover:bg-yellow-500 hover:text-white">
                        Kategori ▼
                    </button>
                    <div id="category-submenu" class="hidden ml-4">
                        <?php if (!empty($categories)): ?>
                            <?php foreach ($categories as $category): ?>
                                <a href="<?= site_url('category/' . $category->slug); ?>"
                                    class="block py-2 px-3 rounded hover:bg-yellow-500 hover:text-white">
                                    <?= htmlspecialchars($category->name); ?>
                                </a>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <span class="block py-2 px-3 text-gray-400">Tidak ada kategori</span>
                        <?php endif; ?>
                    </div>
                    <a href="<?= site_url('user/profile'); ?>"
                        class="block py-2 px-3 rounded hover:bg-yellow-500 hover:text-black">Profile</a>
                    <a href="<?= site_url('auth/logout'); ?>"
                        class="block py-2 px-3 rounded hover:bg-yellow-500 hover:text-black">Logout</a>
                </nav>
            </aside>

            <!-- Main content -->
            <main class="flex-grow p-6 bg-white rounded-lg shadow min-h-screen">
                <div class="max-w-5xl mx-auto">
                    <h2 class="text-2xl font-bold text-gray-800 mb-2">Welcome,
                        <?= htmlspecialchars($user->username); ?>
                    </h2>
                    <p class="text-gray-500 mb-6"><?= date('l, d F Y'); ?></p>

                    <div class="bg-white rounded-2xl shadow-lg p-8">
                        <form id="profile-form" enctype="multipart/form-data" method="post"
                            action="<?= site_url('user/update_profile'); ?>">
                            <!-- Header Profile -->
                            <div class="flex items-center justify-between mb-6">
                                <div class="flex items-center space-x-4">
                                    <div class="relative">
                                        <?php
                                        $profile_image = $user->profile_image ?? 'assets/uploads/profile_images/default.png';
                                        $profile_image_url = base_url($profile_image);
                                        ?>
                                        <img src="<?= htmlspecialchars($profile_image_url); ?>" alt="Profile Picture"
                                            class="profile-image-preview w-16 h-16 rounded-full object-cover">
                                        <label for="profile-image-input"
                                            class="profile-image-upload absolute bottom-0 right-0 bg-blue-500 text-white rounded-full w-6 h-6 flex items-center justify-center cursor-pointer text-xs">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 4v16m8-8H4" />
                                            </svg>
                                        </label>
                                        <input type="file" id="profile-image-input" name="profile_image"
                                            accept="image/*" class="hidden">
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-semibold text-gray-800 username-display">
                                            <?= htmlspecialchars($user->username); ?>
                                        </h3>
                                        <p class="text-gray-500 email-display">
                                            <?= htmlspecialchars($user->email); ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <button type="button" id="edit-btn"
                                        class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg">Edit</button>
                                    <button type="submit" id="save-btn"
                                        class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded-lg hidden">Save</button>
                                    <button type="button" id="cancel-btn"
                                        class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg hidden">Cancel</button>
                                </div>
                            </div>

                            <!-- Form Grid - Read Mode -->
                            <div id="read-mode" class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-600">Full Name</label>
                                    <p class="mt-1 text-gray-900 read-full_name">
                                        <?= htmlspecialchars($user->full_name ?? 'Not provided'); ?>
                                    </p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-600">Username</label>
                                    <p class="mt-1 text-gray-900 read-nick_name">
                                        <?= htmlspecialchars($user->user_name ?? 'Not provided'); ?>
                                    </p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-600">Gender</label>
                                    <p class="mt-1 text-gray-900 read-gender">
                                        <?php
                                        $gender = $user->gender ?? '';
                                        echo $gender === 'male' ? 'Male' : ($gender === 'female' ? 'Female' : 'Not provided');
                                        ?>
                                    </p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-600">Country</label>
                                    <p class="mt-1 text-gray-900 read-country">
                                        <?= htmlspecialchars($user->country ?? 'Not provided'); ?>
                                    </p>
                                </div>
                            </div>

                            <!-- Date of Birth - Read Mode -->
                            <div class="mt-4">
                                <label class="block text-sm font-medium text-gray-600">Date of Birth</label>
                                <p class="mt-1 text-gray-900 read-date_of_birth">
                                    <?php
                                    $dob = $user->date_of_birth ?? '';
                                    echo $dob ? date('F j, Y', strtotime($dob)) : 'Not provided';
                                    ?>
                                </p>
                            </div>

                            <!-- Form Grid - Edit Mode (Hidden by default) -->
                            <div id="edit-mode" class="hidden">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-600">Full Name</label>
                                        <input type="text" name="full_name"
                                            value="<?= htmlspecialchars($user->full_name ?? ''); ?>"
                                            class="mt-1 block w-full rounded-lg border border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 p-2">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-600">Username</label>
                                        <input type="text" name="nick_name"
                                            value="<?= htmlspecialchars($user->user_name ?? ''); ?>"
                                            class="mt-1 block w-full rounded-lg border border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 p-2">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-600">Gender</label>
                                        <select name="gender"
                                            class="mt-1 block w-full rounded-lg border border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 p-2">
                                            <option value="">Select Gender</option>
                                            <option value="male" <?= ($user->gender ?? '') === 'male' ? 'selected' : ''; ?>>Male</option>
                                            <option value="female" <?= ($user->gender ?? '') === 'female' ? 'selected' : ''; ?>>Female</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-600">Country</label>
                                        <input type="text" name="country"
                                            value="<?= htmlspecialchars($user->country ?? ''); ?>"
                                            class="mt-1 block w-full rounded-lg border border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 p-2">
                                    </div>
                                </div>

                                <!-- Date of Birth - Edit Mode -->
                                <div class="mt-4">
                                    <label class="block text-sm font-medium text-gray-600">Date of Birth</label>
                                    <input type="date" name="date_of_birth"
                                        value="<?= htmlspecialchars($user->date_of_birth ?? ''); ?>"
                                        class="mt-1 block w-full rounded-lg border border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 p-2">
                                </div>
                            </div>
                        </form>

                        <!-- My Email Address -->
                        <div class="mt-8">
                            <h4 class="text-lg font-semibold text-gray-800 mb-4">My Email Address</h4>
                            <div class="flex items-center space-x-4 bg-gray-50 p-4 rounded-lg">
                                <div class="bg-blue-100 p-2 rounded-full">
                                    <svg class="w-6 h-6 text-blue-500" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M16 12H8m0 0H5m3 0h11m-7-6h.01M12 6h.01M21 12.001c0 4.97-4.03 9-9 9s-9-4.03-9-9c0-4.971 4.03-9 9-9s9 4.029 9 9z" />
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-gray-800"><?= htmlspecialchars($user->email); ?></p>
                                    <p class="text-gray-400 text-sm">1 month ago</p>
                                </div>
                            </div>
                            <a href="<?= site_url('password-reset') ?>"
                               class="mt-4 bg-blue-50 text-blue-600 px-4 py-2 rounded-lg border border-blue-200 hover:bg-blue-100">
                                Change Password
                            </a>
                        </div>
                    </div>

                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mt-4"
                            role="alert">
                            <span class="block sm:inline"><?= $this->session->flashdata('success'); ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mt-4"
                            role="alert">
                            <span class="block sm:inline"><?= $this->session->flashdata('error'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </main>
        </div>

        <footer class="bg-gray-800 p-4 text-center text-gray-400">
            &copy; 2025 Klimaks.com. All rights reserved.
        </footer>
    </div>

    <script src="<?= base_url('assets/js/sidebar/user_profile.js'); ?>"></script>
</body>

</html>