// Sidebar toggle
const sidebarToggle = document.getElementById('sidebar-toggle');
const sidebar = document.getElementById('sidebar');

sidebarToggle.addEventListener('click', () => {
    sidebar.classList.toggle('-translate-x-full');
});

// Category submenu toggle (mobile)
document.addEventListener('DOMContentLoaded', () => {
    const toggle = document.getElementById('category-toggle');
    const submenu = document.getElementById('category-submenu');

    if (toggle && submenu) {
        toggle.addEventListener('click', () => {
            submenu.classList.toggle('hidden');
        });
    }

    // Edit profile form toggle
    const editBtn = document.getElementById('edit-btn');
    const saveBtn = document.getElementById('save-btn');
    const cancelBtn = document.getElementById('cancel-btn');
    const readMode = document.getElementById('read-mode');
    const editMode = document.getElementById('edit-mode');
    const profileForm = document.getElementById('profile-form');

    let originalValues = {};

    function toggleEditMode(enable) {
        if (enable) {
            readMode.classList.add('hidden');
            editMode.classList.remove('hidden');
            editBtn.classList.add('hidden');
            saveBtn.classList.remove('hidden');
            cancelBtn.classList.remove('hidden');
        } else {
            readMode.classList.remove('hidden');
            editMode.classList.add('hidden');
            editBtn.classList.remove('hidden');
            saveBtn.classList.add('hidden');
            cancelBtn.classList.add('hidden');
        }
    }

    function saveOriginalValues() {
        originalValues.full_name = profileForm.elements['full_name'].value;
        originalValues.nick_name = profileForm.elements['nick_name'].value;
        originalValues.gender = profileForm.elements['gender'].value;
        originalValues.country = profileForm.elements['country'].value;
        originalValues.date_of_birth = profileForm.elements['date_of_birth'].value;
    }

    function restoreOriginalValues() {
        profileForm.elements['full_name'].value = originalValues.full_name;
        profileForm.elements['nick_name'].value = originalValues.nick_name;
        profileForm.elements['gender'].value = originalValues.gender;
        profileForm.elements['country'].value = originalValues.country;
        profileForm.elements['date_of_birth'].value = originalValues.date_of_birth;
    }

    editBtn.addEventListener('click', () => {
        saveOriginalValues();
        toggleEditMode(true);
    });

    cancelBtn.addEventListener('click', () => {
        restoreOriginalValues();
        toggleEditMode(false);
    });

    // Save button submits form normally (server side)
});
