// Simple horizontal swipe slider for mobile
document.querySelectorAll(".overflow-x-auto").forEach((container) => {
	let isDown = false;
	let startX;
	let scrollLeft;

	container.addEventListener("mousedown", (e) => {
		isDown = true;
		container.classList.add("active");
		startX = e.pageX - container.offsetLeft;
		scrollLeft = container.scrollLeft;
	});

	container.addEventListener("mouseleave", () => {
		isDown = false;
		container.classList.remove("active");
	});

	container.addEventListener("mouseup", () => {
		isDown = false;
		container.classList.remove("active");
	});

	container.addEventListener("mousemove", (e) => {
		if (!isDown) return;
		e.preventDefault();
		const x = e.pageX - container.offsetLeft;
		const walk = (x - startX) * 2; //scroll-fast
		container.scrollLeft = scrollLeft - walk;
	});

	// Touch events for swipe support
	container.addEventListener("touchstart", (e) => {
		startX = e.touches[0].pageX - container.offsetLeft;
		scrollLeft = container.scrollLeft;
	});

	container.addEventListener("touchmove", (e) => {
		const x = e.touches[0].pageX - container.offsetLeft;
		const walk = (x - startX) * 2;
		container.scrollLeft = scrollLeft - walk;
	});
});
