-- Query untuk membuat tabel password_resets
CREATE TABLE IF NOT EXISTS `password_resets` (
    `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `email` VARCHAR(255) NOT NULL,
    `token` VARCHAR(255) NOT NULL,
    `created_at` DATETIME NOT NULL,
    `expires_at` DATETIME NOT NULL,
    `used` TINYINT(1) DEFAULT 0,
    PRIMARY KEY (`id`),
    KEY `email` (`email`),
    KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Query untuk menambahkan kolom reset_token ke tabel users (opsional)
-- ALTER TABLE `users` ADD COLUMN `reset_token` VARCHAR(255) DEFAULT NULL;

-- Query untuk membersihkan token yang sudah kadaluarsa
DELETE FROM `password_resets` WHERE `expires_at` < NOW();

-- Query untuk membersihkan token yang sudah digunakan
DELETE FROM `password_resets` WHERE `used` = 1;

-- Contoh data untuk testing
-- INSERT INTO `password_resets` (`email`, `token`, `created_at`, `expires_at`) 
-- VALUES ('test@example.com', 'randomtoken123', NOW(), DATE_ADD(NOW(), INTERVAL 1 HOUR));
